//______________________________________________________________________________

//	The Java Virtual Shelf

//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.ToolBox;
import org.ariane.exec.BackgroundCommand;
import org.ariane.security.SecurityException;
import java.net.URL;
import java.io.InputStreamReader;
import java.io.BufferedReader;

/**
 * RemoteCommand : used to run remotely a command on a server.
 * <P>
 * It is a very simple implementation and potentially dangerous !
 * The name of the command is passed to a cgi script managed by a
 * web server.
 *
 * @see	Thread
 * @version $Id: RemoteCommand.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class RemoteCommand  extends BackgroundCommand  {
  /**
   * @serial The command line to be executed.
   */
private	String	cmd;

//______________________________________________________________________________
/**
 * Creates a RemoteCommand.
 * <Br>
 * For sake of security only <Code>fortune</Code> is allowed.
 * @param c the command to be executed.
 * @throw SecurityException if the command is not allowed.
 */
public RemoteCommand(String c) throws SecurityException
  {
      if(c.equals("fortune")) {
	  cmd = c;
      }
      else {
	  throw new SecurityException("Command not permitted :" + c);
      }
  }
//______________________________________________________________________________
/**
 * Executes the command on the remote host.
 * A cgi script is used to run the command. Communication is handled
 * by http.
 */
public void run()
  {
      done  = false;
      String wrapper = "http://seipca185.saclay.cea.fr/cgi-bin/wrapper.cgi?";

      try { 

	  URL 		 url = new URL(wrapper + cmd);
	  BufferedReader in  = new BufferedReader(
			       new InputStreamReader(url.openStream()));
	  String 	line = in.readLine();
	  output = line + "\n";

	  while((line = in.readLine()) != null) {
	      output += line + "\n";
	  }

      } catch (Exception ex) { 
	  ToolBox.warn("Can't run command", ex); 
      }

      done   = true;
  }
//______________________________________________________________________________
/**
 * Returns a count.
 */
private	int count()
  {
      int n = 10;

      int i = cmd.indexOf(' ');
      if(i < 0)
	  return n;
      try {
	  String s = cmd.substring(i).trim();
	  n = Integer.parseInt(s);
      }
      catch(NumberFormatException ex) {}

      return n;
  }
//______________________________________________________________________________
}




