//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.ToolBox;

/** 
 * OurDomain : an object corresponding to our domain.
 * The definition of the domain for Saclay has to be improved.
 * @see NetHost
 * @version $Id: OurDomain.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
final	public	class OurDomain extends NetDomain {

  /**
   * The unique instance.
   */
private  static	OurDomain domain = null;

//______________________________________________________________________________
/**
 * Getq an unique instance of OurDomain.
 * It is a singleton.
 */
public static	OurDomain instance()
  {
    if(domain == null)
	domain = new OurDomain();

    return domain;
  }
//______________________________________________________________________________
/**
 * Creates the NetDomain.
 */
private OurDomain()
  {
      super("saclay.cea.fr");

      String[] nets = {
	  "132.166.28.0",
	  "132.166.29.0",
	  "132.166.30.0",
	  "132.166.31.0",
	  "132.166.39.0",
	  "132.166.85.0",
	  "132.166.139.0",
	  };
      super.define(nets);
  }
//______________________________________________________________________________
/**
 * Our domain is already defined.
 * @parameter nets the array of Class C addresses
 */
final public void define(String[] nets)
  {
  }
//______________________________________________________________________________
}




