//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.Nobject;

/** 
 * NetSite : a object describing a site in the internet.
 * @see NetHost
 * @version $Id: NetSite.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
public	class NetSite extends Nobject {
  /**
   * @serial The fully qualified domain name : hostname.organisation.toplevel
   */
private String fqdn;
  /**
   * @serial A short explanation of what the site is.
   */
private String description;
  /**
   * @serial The prefix used in the URLs
   */
public static	final String HTTP_PREFIX = "http://";
public static	final String FTP_PREFIX  = "ftp://";

//______________________________________________________________________________
/**
 * Creates a NetSite named 'sitename'. The name is used to identify the site.
 * It may have nothing to do with the domain name.
 * @parameter sitename the name for this site.
 * @parameter fqdn the domain name where the site is located.
 * @exception IllegalArgumentException if an argument is null.
 */
public NetSite(String sitename, String fqdn) throws IllegalArgumentException
  {
      super(sitename);
      if(sitename == null || fqdn == null) {
	throw new IllegalArgumentException("Invalid names");
      }

      this.fqdn   = fqdn;
      description = null;
  }
//______________________________________________________________________________
/**
 * Returns the domain name where the site is located.
 * @return the fully qualified name.
 */
final public String getFQDN()
  {
    return fqdn;
  }
//______________________________________________________________________________
/**
 * Returns the description of this site.
 * @return the text of the description.
 */
final public String getDescription()
  {
    return description;
  }
//______________________________________________________________________________
/**
 * Stores the description of this site.
 * @parameter the text of the description.
 */
final public void  setDescription(String description)
  {
    this.description = description;
  }
//______________________________________________________________________________
/**
 * Builds a string from info given by this object.
 * @return str	the string.
 */
public String	toString()
  {
    return "Site : " + getName() + " at " + fqdn;
  }
//______________________________________________________________________________
/**
 * Returns the string fqdn.
 * @return the url.
 */
public String getURLString()
  {
    return getFQDN();
  }
//______________________________________________________________________________

}




