//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.Nobject;
import java.net.InetAddress;
import java.net.UnknownHostException;

/** 
 * NetHost : a object describing an host plugged to the network.
 * @see NetDomain
 * @version $Id: NetHost.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
public	class NetHost extends Nobject {


//______________________________________________________________________________
/**
 * Creates a NetHost named 'hostname'.
 */
public NetHost(String hostname)
  {
      super(hostname);
  }
//______________________________________________________________________________
/**
 * Creates a NetHost for the local host. The name is automatically guessed.
 * @see InetAddress
 */
public NetHost()
  {
      try {
	  setName(InetAddress.getLocalHost().getHostName());
      }
      catch(UnknownHostException ex) {
	  setName("localhost");
      }
  }
//______________________________________________________________________________
/**
 * Builds a string from info given by this object
 * @return str	the string.
 */
public String	toString()
  {
    return "Host : " + getName();
  }
//______________________________________________________________________________
/**
 * Checks to see if this host belongs to an Internet domain.
 * @parameter domain the domain in which to look.
 * @return true if it is in the domain.
 * @see NetDomain#has
 */
final public boolean isInDomain(NetDomain domain)
  {
    return domain.has(this);
  }
//______________________________________________________________________________
/**
 * Returns the IP number of this host.
 * @return the string nn.nn.nn.nn
 * @see InetAddress
 */
final public String getIPnumber()
  {
      try {
	  byte[]       ba = getAddress();
	  StringBuffer ip = new StringBuffer(16);

	  ip.append(ba[0] & 0x00FF).append(".");
	  ip.append(ba[1] & 0x00FF).append(".");
	  ip.append(ba[2] & 0x00FF).append(".");
	  ip.append(ba[3] & 0x00FF);

	  return ip.toString();
      }
      catch(UnknownHostException ex) {
	  return "";
      }
  }
//______________________________________________________________________________
/**
 * Returns the IP number of this host.
 * @return the array of bytes nn.nn.nn.nn
 * @exception UnknownHostException
 * @see InetAddress
 */
final public byte[] getAddress() throws UnknownHostException
  {
      return InetAddress.getLocalHost().getAddress();
  }
//______________________________________________________________________________
}







