//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.Nobject;
import org.ariane.tools.ToolBox;
import java.util.StringTokenizer;
import java.net.UnknownHostException;

/** 
 * NetDomain : a object describing a subnetwork.
 * @see NetHost
 * @version $Id: NetDomain.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
public	class NetDomain extends Nobject {

  /**
   * @serial the array of ip numbers nnn.nnn.nnn[.*]
   * subnets[i][j] i is the address index, j the byte index.
   */
private	byte[][] subnets;

//______________________________________________________________________________
/**
 * Creates a NetDomain named 'domain'.
 * @parameter domain the name of the domain.
 */
public NetDomain(String domain)
  {
      super(domain);
  }
//______________________________________________________________________________
/**
 * Checks to see if an host belongs to the domain.
 * @parameter host the host to check.
 * @return true if the host is in the domain, false otherwise.
 * @see NetHost#isInDomain
 */
public boolean has(NetHost host)
  {
       try {
	  byte[] ip = host.getAddress();
	  int n	    = subnets.length;

	  for(int i = 0; i < n; i++) {
	      if(isInSubnet(ip, subnets[i]))
		  return true;
	  }

	  return false;
      }
      catch(UnknownHostException ex) {
	  return false;
      }
  }
//______________________________________________________________________________
/**
 * Defines the NetDomain.
 * @parameter nets the array of Class C addresses.
 */
public void define(String[] nets)
  {
      int n   = nets.length;
      subnets = new byte[n][3];

      for(int i = 0; i < n; i++) {
	  addNet(nets[i], subnets[i]);
      }
  }
//______________________________________________________________________________
/**
 * Builds a string from info given by this object
 * @return str	the string.
 */
public String	toString()
  {
      StringBuffer buf	= new  StringBuffer();
      int n   		= subnets.length;

      for(int i = 0; i < n; i++) {
	 buf.append(subnets[i][0] & 0x00FF).append(".");
	 buf.append(subnets[i][1] & 0x00FF).append(".");
	 buf.append(subnets[i][2] & 0x00FF).append(".* ");
      }

      return "Domain : " + getName() + " [ " + buf.toString() + "] ";
  }
//______________________________________________________________________________
/**
 * Adds a single subnet to the array of subnets defining the domain.
 * Converts the string into an array of 3 bytes.
 * @parameter n the string of 3 bytes nnn.nnn.nnn
 * @parameter b the o
 */
private void addNet(String n, byte[] b)
  {
      StringTokenizer stk = new StringTokenizer(n, ".");
      String str;
      int    bip;

      try {
	  str  = stk.nextToken();
	  bip  = Integer.parseInt(str);
	  b[0] = (byte)bip;

	  str  = stk.nextToken();
	  bip  = Integer.parseInt(str);
	  b[1] = (byte)bip;

	  str  = stk.nextToken();
	  bip  = Integer.parseInt(str);
	  b[2] = (byte)bip;
      }
      catch(Exception ex) {
	  ToolBox.warn("Invalid address " + n, ex);
	  throw new IllegalArgumentException(n);
      }
  }
//______________________________________________________________________________
/**
 * Checks to see if an host belongs to the subnet.
 * @parameter ip the host ip number to check.
 * @parameter net the subnet to check.
 * @return true if the host is in the subnet, false otherwise.
 */
final public boolean isInSubnet(byte[] ip, byte[] net)
  {
      return (ip[0] == net[0]) && (ip[1] == net[1]) && (ip[2] == net[2]);
  }
//______________________________________________________________________________
}

