//______________________________________________________________________________

//	The Java Virtual Shelf

//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.ToolBox;
import org.ariane.exec.BackgroundCommand;
import java.net.Socket;
import java.net.InetAddress;
import java.io.*;

/**
 * MailBack : used to send back a message to the applet user..
 * @see	Thread
 * @version $Id: MailBack.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class MailBack  extends BackgroundCommand  {
  /**
   * @serial The socket used by the connection.
   */
private Socket sock = null;
  /**
   * @serial The receiver of the message.
   * Ought to be the author since it's a mail back.
   */
private String receiver = null;
  /**
   * @serial The subject of the message.
   */
private String subject = "Mad Max Mailback";
  /**
   * @serial The text of the message.
   */
private String text = "";

private static final	String mailer  = "dphdse.saclay.cea.fr";
private static final	String sender  = "lefevre@hep.saclay.cea.fr";
private static final	String author  = "the Java Virtual Shelf";
private static final	String filet   =
"____________________________________________________________________________";

//______________________________________________________________________________
/**
 * Creates a MailBack.
 */
public MailBack()
  {
  }
//______________________________________________________________________________
/**
 * Creates a MailBack with a subject.
 * @param s the subject.
 */
public MailBack(String s)
  {
     setSubject(s); 
  }
//______________________________________________________________________________
/**
 * Sets the address of the receiver.
 * @param rcv the email address.
 */
final public void setReceiver(String rcv)
  {
      receiver = rcv;
  }
//______________________________________________________________________________
/**
 * Sets the subject of the message.
 * @param s the subject.
 */
final public void setSubject(String s)
  {
      subject = s;
  }
//______________________________________________________________________________
/**
 * Sets the content of the message.
 * @param txt the text.
 */
final public void setText(String txt)
  {
      text = txt == null ? "" : txt;
  }
//______________________________________________________________________________
/**
 * Executes the command on the remote host.
 * The procedure corresponds to the protocol as described in RFC 821.
 */
public void run()
  {
      done  = false;
      if(receiver == null) {
	  ToolBox.warn("Invalid null receiver address");
	  done = true; return;
      }
      else if(receiver.indexOf('@') < 0) {
	  ToolBox.warn("Invalid receiver address " + receiver);
	  done = true; return;
      }

      try {
	  if(ToolBox.debug) ToolBox.warn("Contacting " + mailer);
	  sock = new Socket(mailer, 25);
      }
      catch(Exception ex) {
	  ToolBox.warn("Can't connect to " + mailer, ex);
	  done = true; return;
      }

      BufferedReader in;
      PrintWriter    out;

      try {
	  in  = new BufferedReader(
		new InputStreamReader(sock.getInputStream()));
	  out = new PrintWriter(sock.getOutputStream(), true);
      }
      catch(IOException ex) {
      	  ToolBox.warn("Can't open streams to " + mailer, ex);
	  closeConnection();
	  return;
      }
      if(ToolBox.debug) ToolBox.warn("Connected to " + mailer);

      String line = getLine(in);

      out.println("HELO " + mailer);
      if(! isOK(in)) {
	  ToolBox.warn("Can't greet " + mailer);
	  closeConnection(); return;
      }

      out.println("MAIL FROM: " + sender);
      if(! isOK(in)) {
	  ToolBox.warn("Can't send message from " + sender);
	  closeConnection(); return;
      }

      out.println("RCPT TO: " + receiver);
      if(! isOK(in)) {
	  ToolBox.warn("Can't send message to " + receiver);
	  closeConnection(); return;
      }

      out.println("DATA");
      if(! isReady(in)) {
	  ToolBox.warn("Can't send data");
	  closeConnection(); return;
      }

      out.println("To: " + receiver);
      out.println("Subject: " + subject);
      out.println("From: \""  + author + "\" <" + sender + ">");
      out.println("");

      sendHeader(out);
      sendText(out);

      out.println(".");
      getLine(in);
      out.println("quit");

      closeConnection();
      done = true;
  }
//______________________________________________________________________________
  /**
   * Reads a line from the server and check the answer.
   */
private boolean isOK(BufferedReader in)
  {
      return getLine(in).regionMatches(0, "250", 0, 3);
  }
//______________________________________________________________________________
  /**
   * Reads a line from the server and check the answer.
   */
private boolean isReady(BufferedReader in)
  {
      return getLine(in).regionMatches(0, "354", 0, 3);
  }
//______________________________________________________________________________
  /**
   * Sends the header of the message
   */
private void sendHeader(PrintWriter out)
  {
      out.println(filet); out.println();
      out.println("Greetings,");
      out.println(
      "This message was sent automatically by the JVS Mailback Procedure.");

      String host;
      try {
	  host = InetAddress.getLocalHost().getHostName();
	  if(host == null) host = InetAddress.getLocalHost().toString();
      }
      catch(Exception ex) {
	  host = "unknown";
      }
      out.println("It was launched from host : " + host + " thru " +
		  System.getProperty("browser", "Unknown") + ".");

      out.println(filet);
  }
//______________________________________________________________________________
  /**
   * Sends the text of the message
   */
private void sendText(PrintWriter out)
  {
      out.println();
      out.print(text);
      out.println();
      out.print(filet);
      out.println();
  }
//______________________________________________________________________________
/**
 * Returns a line read from the SMTP server.  This is a method simply to
 * avoid numerous or unclear try/catch sequences.
 * @param in the input stream
 * @return      The line read from the server.
 */
private	String getLine(BufferedReader in)
{
    String line;

    try {
      line = in.readLine();
    }
    catch(IOException ex){

	ToolBox.warn("Can't read line", ex);
	closeConnection();
	done = true;
	stop();
	return null;
    }

    return line;
  }
//______________________________________________________________________________
/**
 * Closes the connection to the SMTP server.
 */
private	void closeConnection()
{
    try {
	sock.close();
    }
    catch(IOException ex) {
	ToolBox.warn("Can't close connection", ex);
	done = true;
    }
}
//______________________________________________________________________________
}




