//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package	org.ariane.net;

import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;
import org.ariane.net.HostTag;
import org.ariane.net.NetHost;

/**
 * LocalTouch : a test program for the net package.
 *
 * @version $Id: LocalTouch.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class LocalTouch extends TryProg {
  /*
   * The tag for the local host
   */
private	HostTag	tag;

//______________________________________________________________________________

public static void main (String args[])
  {
    LocalTouch prog = new LocalTouch();

    if (! prog.parseArg(args)) {
      ToolBox.warn("Can't parse command line");
      return;
    }

    if (! prog.run()) {
      ToolBox.warn("Can't execute command");
      return;
    }
  }
//______________________________________________________________________________

public LocalTouch()
  {
    super("LocalTouch");
    tag = new HostTag("localhost");
  }
//______________________________________________________________________________
  /**
   * Executes the program
   */
public	boolean run()
  {
    boolean again = true;

    while(again) {

	tag.touch();
	ToolBox.warn("Running LocalTouch with " + tag.toString() + " ...");

	System.out.print("Touch again ? ");
	String answer = getInputString();
	System.out.println();
	again = answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("y");
    }

    return true;
  }
//______________________________________________________________________________
  /**
   * Reads a string from standard input
   */
private	String getInputString()
  {
      return ToolBox.readInputString();
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * Usage   : -v|d
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

