//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

import org.ariane.time.Time;
import org.ariane.tools.VersionInfo;
import org.ariane.tools.Resources;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

/**
 * A base servlet for the JVS.
 *
 * @version $Id: JvsServlet.java,v 3.1 2000/12/05 11:40:35 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

public class JvsServlet extends HttpServlet {
    /**
     * @serial The set of properties.
     */
    protected Resources resources;
    /**
     * The name of the attribute errorbean.
     */
    final static private String ERROR = "errorbean";

//______________________________________________________________________________
/**
 * Does some initialization.
 * <P>
 * Prints a message in the log file.
 */
public void init() throws ServletException
{
    log("JvsServlet. " + VersionInfo.instance().toString());
    log("Started on "  + new Time());
    log("Classpath : "  + System.getProperty("java.class.path"));

    setResources();

    if(false) log(resources.getPropertyValues());
}
//______________________________________________________________________________
/**
 * Installs the resources.
 * <Br>
 * This method can be overriden in subClasses to use different resources.
 * @see	Resources#load
 */
protected void setResources()
  {
      resources = Resources.instance();
      resources.load();
  }
//______________________________________________________________________________
/**
 * Does some clean up.
 * <P>
 * Prints a message in the log file.
 */
public void destroy()
{
    log("JvsServlet killed on "  + new Time());
    super.destroy();
}
//______________________________________________________________________________
/**
 * Handles the HTTP GET method.
 * <Br>
 * This implementation calls the common handler.
 *
 * @param request contains the request the client has made of the servlet.
 * @param response contains the response the servlet sends to the client.
 * @throw IOException if an input or output error is detected.
 * @throw ServletException if the request for the GET could not be handled.
 * @see #handleRequest
 */
public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
{
    handleRequest(request, response);
}
//______________________________________________________________________________
/**
 * Handles the HTTP POST method.
 * <Br>
 * This implementation calls the common handler.
 *
 * @param request contains the request the client has made of the servlet.
 * @param response contains the response the servlet sends to the client.
 * @throw IOException if an input or output error is detected.
 * @throw ServletException if the request for the POST could not be handled
 * @see #handleRequest
 */
public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
{
    handleRequest(request, response);
}
//______________________________________________________________________________
/**
 * Handles the request.
 *
 * @param request contains the request the client has made of the servlet.
 * @param response contains the response the servlet sends to the client.
 * @throw IOException if an input or output error is detected.
 * @throw ServletException if the request for the POST could not be handled
 */
protected void handleRequest(HttpServletRequest request,
			   HttpServletResponse response)
	throws ServletException, IOException
{
    logRequest(request);
}
//______________________________________________________________________________
/**
 * Logs the request.
 *
 * @param rq contains the request the client has made of the servlet.
 * @throw ServletException if the request for the POST could not be handled
 */
protected void logRequest(HttpServletRequest rq)
{
    StringBuffer buf = new StringBuffer("JVS : ");
    buf.append(rq.getRemoteHost()).append(" ");
    buf.append(rq.getSession().getId()).append(" ").append(new Time());

    log(buf.toString());
}
//______________________________________________________________________________
/**
 * Returns an error bean.
 * <P>
 * It is created if necessary and stored in the session.
 * param session the current session.
 * @return the bean.
 */
protected ErrorBean getErrorBean(HttpSession session)
{
    ErrorBean error = (ErrorBean)session.getAttribute(ERROR);

    if(error == null) {
	error = new ErrorBean();
	session.setAttribute(ERROR, error);
    }

    return error;
}
//______________________________________________________________________________
}








