//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package	org.ariane.net;

import org.ariane.tools.Nobject;
import org.ariane.stats.Countable;
import java.util.Date;
import java.text.SimpleDateFormat;

/**
 * HostTag : an object dealing with networking.
 *
 * @see NetHost
 * @version $Id: HostTag.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */
class HostTag extends Nobject implements Countable {
  /**
   * @serial The current count.
   */
  private	int	count;
  /**
   * @serial The last touch date.
   */
  private	Date	hour;
  /**
   * @serial The host in question.
   */
  private	NetHost	host;

//______________________________________________________________________________
  /**
   * Initialisation
   * @param str the name of the tag.
   * @param nh the nethost.
   */
public HostTag(String str, NetHost nh)
  {
    super(str);
    host  = nh;
    count = 0;
    hour  = new Date();
  }
//______________________________________________________________________________
  /**
   * Initialisation.
   * <P>
   * This HostTag is merely named 'tag'.
   * The object NetHost is created.
   * @param hostname the name of the host.
   */
public HostTag(String hostname)
  {
      this("tag", new NetHost(hostname));
  }
//______________________________________________________________________________
  /**
   * Initialisation.
   * This HostTag is merely named 'tag'.
   * The object NetHost is created.
   */
public HostTag()
  {
      this("tag", new NetHost());
  }
//______________________________________________________________________________
  /**
   * Builds a string from tag content
   * @return the string.
   */
public String	toString()
  {
    return "Tag " + getName() + " on " + host.getName() + " " + getTag();
  }
//______________________________________________________________________________
/**
 * Returns the IP number of the host
 * @return str	the string nn.nn.nn.nn
 * @see NetHost#getIPnumber
 */
final public String getIPnumber()
  {
      return host.getIPnumber();
  }
//______________________________________________________________________________
/**
 * Returns the hostname
 * @return str	the name
 * @see NetHost#getName
 */
final public String getHostName()
  {
      return host.getName();
  }
//______________________________________________________________________________
  /**
   * Returns the current count.
   */
final public synchronized int getCount()
  {
    return count;
  }
//______________________________________________________________________________
  /**
   * Builds and returns the current tag.
   * It is made of the count and the time.
   * @returns the tag
   * @see #touch
   */
private synchronized String getTag()
  {
      StringBuffer tag = new StringBuffer("count ");
      tag.append(count).append(" at ");

      SimpleDateFormat fmt = new SimpleDateFormat("hh 'h' mm 'm'");
      tag.append(fmt.format(hour));

      return tag.toString();
  }
//______________________________________________________________________________
  /**
   * Increments the count.
   */
final public synchronized void  increment()
  {
    count++;
  }
//______________________________________________________________________________
  /**
   * Touches the tag. Increments the count, updates the time.
   * @see #getTag
   */
final public synchronized void touch()
  {
      hour = new Date();
      increment();
  }
//______________________________________________________________________________
}




