//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

/**
 * ErrorBean : a bean storing information about an error.
 * <P>
 * It is meant to send data from a servlet to a jsp.
 *
 * @version $Id: ErrorBean.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

package org.ariane.net;

public class ErrorBean implements java.io.Serializable {

  /**
   * @serial The message.
   */
    private String message;

//______________________________________________________________________________
  /**
   * Creates an empty bean.
   */
    public ErrorBean()
  {
      this.message = "";
  }
//______________________________________________________________________________
  /**
   * Creates a bean.
   * @param message the person's message.
   */
public ErrorBean(String message)
  {
      this.message = message;
  }
//______________________________________________________________________________
  /**
   * Creates a string giving the content of the object.
   * @return the string.
   */
public String toString()
  {
      StringBuffer buf = new
      StringBuffer("Message : ").append(String.valueOf(getMessage()));

      return buf.toString();
  }
//______________________________________________________________________________
  /**
   * Gets the message.
   * @return the string.
   */
final public String getMessage()
  {
      return message;
  }
//______________________________________________________________________________
  /**
   * Sets the message.
   * @param message the message.
   */
final public void setMessage(String message)
  {
      this.message = message;
  }
//______________________________________________________________________________
}
