//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.gui;

import javax.swing.JComponent;
import java.awt.Dimension;

/**
 * Toolbox : a collection of useful procedures for GUI.
 * <P>
 * It is a singleton : the unique instance can be obtained with
 * the static method : <Code>ToolBox.instance()</Code>.
 * @version $Id: ToolBox.java,v 1.1 2001/01/28 11:31:54 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see org.ariane.tools.ToolBox
 */
public final class ToolBox {
  /**
   * @serial The unique instance.
   */
private  static	ToolBox toolbox = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of ToolBox.
 * <br>
 * It is a singleton
 */
public static ToolBox instance()
  {
    if(toolbox == null) toolbox = new ToolBox();

    return toolbox;
  }
//______________________________________________________________________________
  /**
   * Creates the Tool Box.
   * @see #instance
   */
private ToolBox()
  {
  }
//______________________________________________________________________________
/**
 * Sets a fixed size to a component.
 * <Br>
 * The size is the preferred one.
 *
 * @param comp the component to fix.
 * @see #fixComponentSize(JComponent, Dimension)
 */
final static public void fixComponentSize(JComponent comp)
  {
      fixComponentSize(comp, comp.getPreferredSize());
  }
//______________________________________________________________________________
/**
 * Sets a fixed size to a component.
 * <Br>
 * The size, the minimum, maximum, preferred size are set to the specified
 * size.
 *
 * @param comp the component to fix.
 * @param d the dimension to set.
 * @see #fixComponentSize(JComponent)
 */
final static public void fixComponentSize(JComponent comp, Dimension d)
  {
      comp.setSize(d);
      comp.setPreferredSize(d);
      comp.setMinimumSize(d);
      comp.setMaximumSize(d);
  }
//______________________________________________________________________________
}
