//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.gui;

import javax.swing.JProgressBar;
import javax.swing.Timer;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import org.ariane.tools.ToolBox;

/**
 * TimerBar : a object showing a count down.
 *
 * @see JProgressBar
 * @version $Id: TimerBar.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class TimerBar extends JProgressBar {
  /**
   * @serial The timer controlling the display of the count down.
   */
private Timer timer;
  /**
   * @serial The period used to update the bar.
   */
private int period = 100;
    /**
     * @serial The initial time of a count down.
     */
private	long ti;

//______________________________________________________________________________
/**
 * The object TimerBar.
 * <Br>
 * Some default values are set : minimum, orientation.
 */
public	TimerBar()
  {
      super();
      setMinimum(0);
      setStringPainted(false);
      setValue(getMinimum());
      setOrientation(JProgressBar.HORIZONTAL);
  }
//______________________________________________________________________________
/**
 * Changes the period used to update the bar.
 * @param period the value in milliseconds.
 */
final public void setPeriod(int period)
  {
      this.period = period;
  }
//______________________________________________________________________________
/**
 * Starts displaying the progress indicator.
 * <Br>
 * The bar is filled up at the beginning and erased as the time goes.
 *
 * @param duration the time to count down in milliseconds.
 */
final public void start(int duration)
  {
      setMaximum(duration / 1000);
      setValue(getMaximum());
      ti = System.currentTimeMillis();

      if(timer == null) createCounter();
      timer.start();
  }
//______________________________________________________________________________
/**
 * Stops the count.
 *
 * @param duration the time to count down in milliseconds.
 */
final public void stop()
  {
      setMaximum(0);
      setValue(0);
  }
//______________________________________________________________________________
/**
 * Creates the progress timer.
 * <Br>
 * The action which is performed when the timer wakes up is coded in this
 * method. The value stored by the ProgressBar is decremented.
 *
 * @see Timer
 */
private void createCounter()
  {
      timer = new Timer(period, new ActionListener() {

	  public void actionPerformed(ActionEvent evt) {

	      long tc = System.currentTimeMillis();
	      int dt  = getMaximum() - (int)((tc - ti) / 1000);
	      if(dt < 0) {
		  setValue(getMinimum());
		  timer.stop();
		  return;
	      }
	      setValue(dt);
            }
        });
  }
//______________________________________________________________________________
}



