//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.gui;

import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;
import java.awt.*;

/**
 * Prints the list of fonts available on a machine.
 * <br>
 * <code>java org.ariane.gui.ListFonts [-v]</code>
 *
 * @version $Id: ListFonts.java,v 1.1 2001/02/07 20:18:33 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class ListFonts extends TryProg {

//______________________________________________________________________________

public static void main (String args[])
  {

    ListFonts prog = new ListFonts("ListFonts");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute ListFonts !");
      return;
    }
  }
//______________________________________________________________________________

public ListFonts(String name)
  {
    super(name);
  }
//______________________________________________________________________________
    /**
     * Executes the programs. It prints the collection of fonts.
     * @see GraphicsEnvironment
     */    
public	boolean run()
  {
    if(ToolBox.verbose)
      System.out.println("Running ListFonts ...");

    try {
	GraphicsEnvironment env =
                            GraphicsEnvironment.getLocalGraphicsEnvironment();

	String[] list = env.getAvailableFontFamilyNames();

	for(int i = 0; i < list.length; i++) {
	    System.out.println(list[i]);
	}
    }
    catch(Exception ex) {
      ToolBox.warn("Can't prints fonts", ex);
      return false;
    }

    return true;
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * <br>
   * Usage   : [-v]
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

