//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.gui;

import java.awt.*;
import javax.swing.border.Border;
import javax.swing.Icon;

/**
 * Offers values for defining a GUI.
 *
 * @version $Id: GuiResourcesOp.java,v 3.1 2000/10/10 19:37:56 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	interface GuiResourcesOp {
    /**
     * Gets the prefix used to create attibute names.
     * @return the prefix.
     */
    public String getAppplicationPrefix();
    /**
     * Gets an integer value with a possible default value.
     * @param key the key.
     * @param def the default.
     * @return the value.
     * @see org.ariane.tools.Resources#get(String, int)
     */
    public int get(String key, int def);
    /**
     * Gets a string value with a possible default value.
     * @param key the key.
     * @param def the default.
     * @return the value.
     * @see org.ariane.tools.Resources#get(String, String)
     */
    public String get(String key, String def);
    /**
     * Gets a color with a possible default value.
     * @param key the key.
     * @param def the default.
     * @return the value.
     * @see org.ariane.tools.Resources#get(String, Color)
     */
    public Color get(String key, Color def);
    /**
     * Gets the font for the headers.
     * @return the font.
     */
    public Font getHeaderFont();
    /**
     * Gets the font for the labels.
     * @return the font.
     */
    public Font getLabelFont();
    /**
     * Gets the font for the texts.
     * @return the font.
     */
    public Font getTextFont();
    /**
     * Gets the background for the main windows.
     * @return the color.
     */
    public Color getMainBackground();
    /**
     * Gets the foreground for the main windows.
     * @return the color.
     */
    public Color getMainForeground();
    /**
     * Gets the background for the panes.
     * @return the color.
     */
    public Color getPaneBackground();
    /**
     * Gets the foreground for the panes.
     * @return the color.
     */
    public Color getBoardForeground();
    /**
     * Gets the background for the boards.
     * @return the color.
     */
    public Color getBoardBackground();
    /**
     * Gets the foreground for the boards.
     * @return the color.
     */
    public Color getPaneForeground();
    /**
     * Gets the color used for selections.
     * @return the color.
     */
    public Color getSelectionColor();
    /**
     * Gets the common border.
     * @return the border.
     */
    public Border getBorder();
    /**
     * Gets the lowered border.
     * @return the border.
     */
    public Border getInBorder();
    /**
     * Gets the raised border.
     * @return the border.
     */
    public Border getOutBorder();
    /**
     * Gets the line border.
     * @return the border.
     */
    public Border getLineBorder();
    /**
     * Gets the matte border.
     * @return the border.
     */
    public Border getMatteBorder();
    /**
     * Gets the margin border.
     * @return the border.
     */
    public Border getMarginBorder();
    /**
     * Gets the space size.
     * @return the size.
     */
    public int getSpace();
    /**
   * Returns the icon defined by its filename.
   * @parameter filename the name of the file.
   * @return the image icon.
   */
    public Icon getIcon(String filename);
//______________________________________________________________________________
}
