//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.gui;

import javax.swing.*;
import java.awt.Frame;
import org.ariane.tools.ToolBox;

/**
 * A customized Dialog : used to display an error message.
 * <Br>
 * It is a singleton.
 *
 * @version $Id: ErrorWindow.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

abstract public class ErrorWindow extends Dialog {

//______________________________________________________________________________
/**
 * Creates the ErrorWindow.
 * The button ok is unvisible.
 * @param owner the frame from which the dialog is displayed
 */
protected ErrorWindow(Frame owner)
  {
      super(owner, "Error detected !  ", "error.gif");
      ok_button.setVisible(false);
      cancel_button.setToolTipText("To close the window");
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 * @return the component.
 */
protected JComponent createComponent()
{
    JTextArea text      = new JTextArea();

    text.setEditable(false);
    text.setOpaque(true);
    text.setLineWrap(true);
    text.setBackground(resources.getPaneBackground());
    text.setForeground(resources.getPaneForeground());
    text.setFont(resources.getTextFont());
    text.setBorder(makeMarginBorder());

    setInitialSize("Error", 350, 200);

    text.setText("Error !");

    return text;
}
//______________________________________________________________________________
/**
 * Displays the window and waits for a button pressed.
 * <Br>
 * @param message the message to print.
 */
public void display(String message)
{
    ((JTextArea)component).setText(message);

    display();
}
//______________________________________________________________________________
/**
 * Displays the window and waits for a button pressed.
 * <Br>
 * This method formats the message with a header and an exception text.
 *
 * @param message the message to print.
 * @param ex the exception causing the error.
 */
public void display(String message, Exception ex)
{
    display(message, ex.getMessage());
    if(ToolBox.debug) ex.printStackTrace();
}
//______________________________________________________________________________
/**
 * Displays the window and waits for a button pressed.
 * <Br>
 * This method formats the message with a header and an exception text.
 *
 * @param message the message to print.
 * @param reason an explanation of the error.
 */
public void display(String message, String reason)
{
    StringBuffer buf = new StringBuffer(message);
    buf.append("\n\n").append(reason).append('\n');
    display(buf.toString());
}
//______________________________________________________________________________
}

