//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.gui;

import org.ariane.tools.ToolBox;
import java.io.*;
import javax.swing.text.*;
import javax.swing.event.*;

/**
 * A Writer which sends its output to a Document.
 *
 * @see Document
 * @version $Id: ConsoleWriter.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class ConsoleWriter extends Writer {
    /**
     * @serial the area where to write.
     */
    private Document doc;
    /**
     * @serial the attributes used to render the text.
     */
    private SimpleAttributeSet attrs;

//______________________________________________________________________________
/**
 * Creates the Writer.
 * @param doc the document receiving the output.
 */
public ConsoleWriter(Document doc)
  {
      this.doc = doc;
      attrs    = new SimpleAttributeSet();
  }
//______________________________________________________________________________
/**
 * Writes a portion of an array of characters.
 * <P>
 * The characters are appended at the end of the document.
 *
 * @param cbuf the array storing the characters to write.
 * @param off  the offset of the first character to write.
 * @param len  the number of characters to write.
 * @throw IOException if the array of characters cannot be appended.
 * @see Document#insertString
 */
final public void write(char[] cbuf, int off, int len) throws IOException
  {
      try {
	  doc.insertString(doc.getLength(), new String(cbuf, off, len), attrs);
      }
      catch(BadLocationException ex) {
	  throw new IOException(ex.getMessage());
      }
      catch(NullPointerException ex) {
	  throw new IOException(ex.getMessage());
      }
  }
//______________________________________________________________________________
/**
 * Flushes the stream. For this writer there is nothing to do.
 */
final public void flush() throws IOException
  {
      if(doc == null) throw new IOException("Document not available");
  }
//______________________________________________________________________________
/**
 * Closes the stream. The document is no longer referenced.
 */
final public void close() throws IOException
  {
      if(doc == null) return;
      flush();
      doc = null;
  }
//______________________________________________________________________________
}
