//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.exec;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Nobject;

/**
 * RunnableTask : executes a procedure in a thread.
 *
 * @see	Thread
 * @version $Id: RunnableTask.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	abstract class RunnableTask  extends Nobject implements Runnable {
  /**
   * @serial The status of the command.
   */
protected boolean done = false;
  /**
   * @serial The thread.
   */
private	Thread thread = null;

//______________________________________________________________________________
/**
 * Creates a RunnableTask.
 * @param n the name of the task.
 */
public RunnableTask(String c)
  {
      super(c);
  }
//______________________________________________________________________________
/**
 * Creates a RunnableTask.
 */
public RunnableTask()
  {
      super("Task");
  }
//______________________________________________________________________________
/**
 * Returns the encapsulated thread.
 * @return the thread.
 */
final public Thread getThread()
  {
      return thread;
  }
//______________________________________________________________________________
/**
 * Creates then launches the thread.
 * @see Thread#start
 */
public void start()
  {
    if(thread != null && thread.isAlive()) {
	if(ToolBox.debug) ToolBox.warn("Task already alive");
	return;
    }

    try {
	done   = false;
	thread = new Thread(this, getName());
	thread.start();
    }
    catch(Exception ex) {
	ToolBox.warn("Can't start " + getName(), ex);
	thread = null;
	done   = true;
    }
  }
//______________________________________________________________________________
/**
 * Creates then launches the thread.
 * @see Thread#start
 * @parameter group the thread group to which the task belongs.
 */
public void start(ThreadGroup group)
  {
    if(thread != null && thread.isAlive()) {
	if(ToolBox.debug) ToolBox.warn("Task already alive");
	return;
    }
    try {
	done   = false;
	thread = new Thread(group, this, getName());
	thread.start();
    }
    catch(Exception ex) {
	ToolBox.warn("Can't start " + getName(), ex);
	thread = null;
	done   = true;
    }
  }
//______________________________________________________________________________
/**
 * Stops the command if it is running.
 * <Br>
 * Changes the value of the flag done.
 */
public void stop()
  {
      if(thread == null || ! thread.isAlive()) {
	//if(ToolBox.debug) ToolBox.warn("Task already dead");
	return;
      }

      done   = true;
      thread = null;
  }
//______________________________________________________________________________
/**
 * Return the group of threads to which the task belongs.
 * @return the thread group
 */
final public ThreadGroup getGroup()
  {
      if(thread == null) return null;

      return thread.getThreadGroup();
  }
//______________________________________________________________________________
/**
 * Changes the priority of the task.
 * @see Thread#setPriority
 * @param p the new priority.
 */
final public void setPriority(int p)
  {
      try {
	  if(thread != null) thread.setPriority(p);
      }
      catch (Exception ex) {
	  if(ToolBox.debug) ToolBox.warn("Can't set priority", ex);
      }
  }
//______________________________________________________________________________
/**
 * Returns the status.
 * @return true if the task is finished.
 */
public	boolean isDone()
  {
    return done;
  }
//______________________________________________________________________________
/**
 * Converts Task to String.
 * @return str	the string.
 */
public String toString()
  {
    return thread != null ? thread.toString() : "dead";
  }
//______________________________________________________________________________
}




