//______________________________________________________________________________

//	The Java Virtual Shelf

//______________________________________________________________________________

package org.ariane.exec;

/**
 * RandomTask : a simple object to play with Threads.
 * @version $Id: RandomTask.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le F&egrave;vre
 */
//______________________________________________________________________________

public	class RandomTask extends Thread {
  /**
   * The number of times the main loop will be performed.
   */
private	int n = 10;
  /**
   * The number of times the main loop has been executed.
   */
private	int count = 0;

//______________________________________________________________________________
/**
 * Create a RandomTask.
 * @param the name of this task.
 */
public RandomTask(String name)
  {
      this(name, 10);
  }
//______________________________________________________________________________
/**
 * Create a RandomTask.
 * @param name the name of this task.
 * @param nbr the number of loops.
 */
public RandomTask(String name, int nbr)
  {
      super(name);
      n = nbr;
  }
//______________________________________________________________________________
  /**
   * Launch the task
   */
public void run()
{
    count = 0;
    for (int i = 0; i < n; i++) {

	count = i;

	try {
	    sleep((int)(Math.random() * 1000));
	} catch (InterruptedException e) {}
    }
    count = n;
}
//______________________________________________________________________________
/**
 * Return the number of loops done.
 * @return the count.
 */
public int getCount()
  {
    return count;
  }
//______________________________________________________________________________
/**
 * Check to see is the task is completed.
 * @return true is the work is done.
 */
public boolean isDone()
  {
    return count >= n;
  }
//______________________________________________________________________________
}
