//______________________________________________________________________________

//	The Java Virtual Shelf

//______________________________________________________________________________

package org.ariane.exec;

import org.ariane.tools.ToolBox;

/**
 * FakeTask : a simple object meant to play with Threads.
 * <Br>
 * This task does nothing useful. It merely sleeps for the specified amount of
 * time. It may be used for tests.
 *
 * @version $Id: FakeTask.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class FakeTask extends RunnableTask {
  /**
   * @serial The number of milliseconds to work (actually to sleep ;).
   */
private	long laps;
  /**
   * @serial The number of milliseconds to sleep between each check.
   */
static final private long SLEEP_TIME = 200;

//______________________________________________________________________________
/**
 * Creates a FakeTask which will last the specified seconds.
 * @param dt the number of seconds to work.
 */
public FakeTask(int dt)
  {
      laps = 1000 * dt;
      if(ToolBox.verbose) ToolBox.warn("FakeTask created");
  }
//______________________________________________________________________________
  /**
   * Launches the task.
   * <Br>
   * It loops around a sleep of SLEEP_TIME milliseconds. When the
   * total time is elapsed the task stops.
   */
public void run()
{
    long t0 = System.currentTimeMillis();
    if(ToolBox.verbose) ToolBox.warn("FakeTask started");

    while(! done) {

	try {

	    Thread.sleep(SLEEP_TIME);

	    long t1 = System.currentTimeMillis();

	    if((t1 - t0) > (long)laps) {
		break;
	    }

	} catch(InterruptedException ex) {
	    break;
	}
    }

    if(ToolBox.verbose) ToolBox.warn("FakeTask done");
}
//______________________________________________________________________________
}
