//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.exec;

/**
 * ExecutionException : a exception which is thrown when
 * something goes wrong when running a command with 
 * <code>Runtime.exec()</code>.
 *
 * @version $Id: ExecutionException.java,v 1.2 2001/01/15 16:36:58 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class ExecutionException extends RuntimeException {
/**
 * Creates a exception with a generic message.
 */
public ExecutionException()
  {
    this("Execution of the command failed");
  }
//______________________________________________________________________________
/**
 * Creates a exception.
 * @param msg a message to be displayed.
 */
public ExecutionException(String msg)
  {
    super(msg);
  }
//______________________________________________________________________________
}
