//______________________________________________________________________________

//	The Java Virtual Shelf

//______________________________________________________________________________

package org.ariane.exec;

import org.ariane.tools.ToolBox;

/**
 * DebugCommand : used to check RemoteCommand.
 * @see	Thread
 * @version $Id: DebugCommand.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le F&egrave;vre
 */
//______________________________________________________________________________

public	class DebugCommand  extends BackgroundCommand  {

//______________________________________________________________________________
/**
 * Create a DebugCommand.
 * @param c the command to be executed.
 */
public DebugCommand(String c)
  {
      super(c);
  }
//______________________________________________________________________________
/**
 * Execute the command on the remote host.
 */
public void run()
  {
      int n = count();
      done  = false;

      for (int i = 0; i < n; i++) {

	  try {
	      if(ToolBox.verbose) ToolBox.warn("DebugCommand : " + i);
	      long dt = (long)(Math.random() * 10000);
	      Thread.sleep(dt);
	  }
	  catch (InterruptedException e) {
	      if(ToolBox.verbose) ToolBox.warn("DebugCommand interrupted");
	      break;
	  }
      }

      output = new String("RemoteCommand " + count() + " done !");
      done   = true;
  }
//______________________________________________________________________________
/**
 * Returns a count.
 */
final private int count()
  {
      int n = 10;

      return n;
  }
//______________________________________________________________________________
}




