//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.exec;

import org.ariane.tools.ToolBox;
import org.ariane.tools.Nobject;

/**
 * BackgroundCommand : executes a procedure in a thread.
 * @see	Thread
 * @version $Id: BackgroundCommand.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	abstract class BackgroundCommand  extends RunnableTask {
  /**
   * @serial The result of the command.
   */
protected String output = null;

//______________________________________________________________________________
/**
 * Creates a BackgroundCommand.
 * @param c the command to be executed.
 */
public BackgroundCommand(String c)
  {
      super(c);
  }
//______________________________________________________________________________
/**
 * Creates a BackgroundCommand.
 */
public BackgroundCommand()
  {
      super("BackgroundCommand");
  }
//______________________________________________________________________________
/**
 * Returns the output possibly produced by the command.
 * @return the string.
 */
final public String output()
  {
    return isDone() ? output : null;
  }
//______________________________________________________________________________
}




