//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.applet;

import org.ariane.tools.ToolBox;
import java.awt.Rectangle;
import java.awt.Point;

/**
 * A transformation allows to map an area defined in world coordinates
 * to a portion of the screen.
 * @version $Id: Transformation.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le F&egrave;vre
 */

public	final	class Transformation extends Object {

private Point	po;
private float	kx;
private float	ky;

//______________________________________________________________________________
/**
 * Builds the transformation.
 * <br>
 * Finds the bounding box of the set of points.
 * @seeToolBox#upperRoundValue
 * @see #build
 */
public Transformation(float x[], float y[], Rectangle r)
  {
      int n = x.length;

      float x0 =  (float)ToolBox.HUGEVALUE;
      float y0 =  x0;
      float x1 = -x0;
      float y1 =  x1;

      for(int i = 0; i < n; i++) {	// Find the min and max values.

	  if(x[i] < x0) x0 = x[i];
	  if(y[i] < y0) y0 = y[i];
	  if(x[i] > x1) x1 = x[i];
	  if(y[i] > y1) y1 = y[i];

      }

      x0 = (float)ToolBox.upperRoundValue(x0);
      y0 = (float)ToolBox.upperRoundValue(y0);
      x1 = (float)ToolBox.upperRoundValue(x1);
      y1 = (float)ToolBox.upperRoundValue(y1);

      Build(x0, y0, x1, y1, r);
  }
//______________________________________________________________________________
/**
 * Builds the transformation.
 * @see #build
 */
public Transformation(float x0, float y0, float x1, float y1, Rectangle r)
  {
      Build(x0, y0, x1, y1, r);
  }
//______________________________________________________________________________
/**
 * Builds the transformation.
 * <br>
 * It is such as :
 * r.x <-> x0, r.y <-> y0,  r.x + r.width <-> x1, r.y + r.heigth <-> y1,
 * Map the rectangle xy in WC to the rectangle r in SC.
 * @param xy the coordinates in WC.
 * @param r  the coordinates in SC.
 */
private void build(float x0, float y0, float x1, float y1, Rectangle r)
  {
    if(x0 == x1 || y0 == y1) {
	  throw new IllegalArgumentException(
          "Invalid data dx : " 
          + x0 + " " + x1 + " dy : " + y0 + " " + y1 + " !");
    }
    else if(r.width == 0 || r.height == 0) {
	  throw new IllegalArgumentException(
		    "Invalid rectangle " + r.toString() + " !");
    }

      kx = r.width  / (x1 - x0);
      ky = r.height / (y1 - y0);

      po = new Point(Math.round(r.x - kx * x0), Math.round(r.y - ky * y0));
  }
//______________________________________________________________________________
  /**
   * Transforms the WC in SC.
   * @param x the x coordinate in WC.
   * @param y the y coordinate in WC.
   * @return a Point specified in pixels.
   */
public Point from(float x, float y)
  {
      return new Point(Math.round(po.x + kx * x), Math.round(po.y + ky * y));
  }
//______________________________________________________________________________

}




