//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.applet;

import javax.swing.JProgressBar;
import javax.swing.Timer;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import org.ariane.tools.ToolBox;
import org.ariane.exec.RunnableTask;

/**
 * RunnerBar : a object indicating that some task is running.
 * <Br>
 * It is a new implementation using a Swing object. It shows a
 * ProgressBar with the indicator filling up an down the bar.
 *
 * @see JProgressBar
 * @version $Id: RunnerBar.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class RunnerBar extends JProgressBar {
  /**
   * @serial The timer controlling the speed.
   */
private Timer timer;
  /**
   * @serial The task to monitor.
   */
private RunnableTask task;
  /**
   * @serial The current direction (up or down).
   */
private boolean up;
  /**
   * @serial The period used to update the bar.
   */
private int period = 1000;

//______________________________________________________________________________
/**
 * The object RunnerBar.
 * <Br>
 * Some default values are set : minimum, orientation.
 */
public	RunnerBar()
  {
      super();
      setMinimum(0);
      setStringPainted(false);
      setValue(getMinimum());
      setOrientation(JProgressBar.HORIZONTAL);
  }
//______________________________________________________________________________
/**
 * Changes the period used to update the bar.
 * @param period the value in milliseconds.
 */
final public void setPeriod(int period)
  {
      this.period = period;
  }
//______________________________________________________________________________
/**
 * Starts displaying the moving indicator.
 * <Br>
 * The bar will be filled up at the beginning. The timer is created the
 * first time this method is called.
 *
 * @param task the task in progress.
 */
public void start(RunnableTask task)
  {
      this.task = task;
      up        = true;
      if(timer == null) createTimer();
      timer.start();
  }
//______________________________________________________________________________
/**
 * Creates the timer.
 * <Br>
 * The action which is performed when the timer wakes up is coded in this
 * method. The value stored by the ProgressBar is either incremented or
 * decremented depending on its current value within the allowed range.
 *
 * @see Timer
 */
private void createTimer()
  {
      timer = new Timer(period, new ActionListener() {

	  public void actionPerformed(ActionEvent evt) {

	      if(task.isDone()) {
		  timer.stop();
		  setValue(getMinimum());
		  task = null;
		  return;
	      }

	      int t = getValue();
	      if(up) {
		  if(t >= getMaximum()) {
		      t--;
		      up = false;
		  }
		  else {
		      t++;
		  }
	      }
	      else {
		  if(t <= getMinimum()) {
		      t++;
		      up = true;
		  }
		  else {
		      t--;
		  }
	      }
	      setValue(t);
            }
        });
  }
//______________________________________________________________________________
}



