//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.applet;

import org.ariane.tools.ToolBox;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.Timer;

/**
 * Messenger : a object used to display transient messages.
 *
 * @see JLabel
 * @see Timer
 * @version $Id: Messenger.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class Messenger implements  ActionListener {
  /**
   * @serial The widget to update.
   */
private	JLabel widget;
  /**
   * @serial The timer controlling the display.
   */
private	Timer timer;

//______________________________________________________________________________
/**
 * Creates a Messenger.
 * <Br>
 * The default display time is 5 seconds.
 * @param wb the Label to update.
 */
public Messenger(JLabel wb)
  {
      widget = wb;
      timer  = new Timer(5000, this);
      timer.setRepeats(false);
  }
//______________________________________________________________________________
  /**
   * Set the time during when the messages are shown.
   * @parameter dt the new value in seconds.
   * @see Timer#setDelay
   */
final public void setDisplayTime(int dt)
{
    timer.setDelay(dt * 1000);
}
//______________________________________________________________________________
  /**
   * Displays a transient text. Stops the possibly running action.
   * @parameter text the message to display.
   * @see Timer#start
   */
final public void display(String text)
{
    widget.setText(text);
    timer.restart();
}
//______________________________________________________________________________
  /**
   * Displays a permanent text.
   * @parameter text the message to display.
   */
final public void warn(String text)
{
    if(timer.isRunning()) timer.stop();
    widget.setText(text);
}
//______________________________________________________________________________
  /**
   * Clears the text.
   */
final public void erase()
{
    warn(null);
}
//______________________________________________________________________________
  /**
   * Clears the message when the timer triggers this action.
   *
   * @param ev the event.
   */
public void actionPerformed(ActionEvent ev)
{
    widget.setText(null);
}
//______________________________________________________________________________
}



