//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.applet;

import java.awt.*;
import javax.swing.JFrame;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import org.ariane.tools.ToolBox;

/**
 * MainFrame : a component used as the main windown for application gui.
 * @version $Id: MainFrame.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class MainFrame extends JFrame implements WindowListener {
/**
 * @serial The flag indicating whether the frame is used on the web.
 */
protected boolean onweb = true;

//______________________________________________________________________________
/**
 * Create the object.
 * @param str the title of the frame.
 */
public	MainFrame(String title)
  {
      this(title, true);
  }
//______________________________________________________________________________
/**
 * Create the object.
 * @param str the title of the frame.
 * @param isapplet true if in applet.
 */
public	MainFrame(String title, boolean isapplet)
  {
      super(title);
      onweb = isapplet;
      addWindowListener(this);
  }
//______________________________________________________________________________
/**
 * Destroy the window
 */
public void kill()
{
	if(onweb) {
	    dispose();
	}
	else {
	    System.exit(0);
	}
}
//______________________________________________________________________________
/**
 * Handle event : exit if requested.
 * @param e the event
 */
public void windowClosed(WindowEvent e)
{
	kill();
}
//______________________________________________________________________________
/**
 * Handle event
 * @param e the event
 */
public void windowActivated(WindowEvent e) {}
public void windowClosing(WindowEvent e) {}
public void windowDeactivated(WindowEvent e) {}
public void windowIconified(WindowEvent e) {}
public void windowDeiconified(WindowEvent e) {}
public void windowOpened(WindowEvent e) {}
//______________________________________________________________________________
}

