//______________________________________________________________________________

//	Java Object Library
//______________________________________________________________________________

package org.ariane.applet;

import java.awt.*;

/**
 * LabelGadget : a label with a transparent background.
 * <P>
 * It is a pre-swing object, it must not be used.
 *
 * @version $Id: LabelGadget.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le Fevre
 */

public	class LabelGadget extends Gadget {

public 	static final int      LEFT   = Label.LEFT;
public 	static final int      RIGHT  = Label.RIGHT;
public 	static final int      CENTER = Label.CENTER;

/**
 * @serial The justification
 */
private int      alignment;
/**
 * @serial An inter space
 */
private int	margin = 2;
/**
 * @serial The text of the label
 */
private String	label;

//______________________________________________________________________________
/**
 * The gadget Label.
 * @param parent the component holding the Label.
 * @param str the text of the Label.
 * @param al the justification (RIGHT, LEFT or CENTER).
 */
public	LabelGadget(Component parent, String str, int al)
{
    super(parent);

    if(al != RIGHT && al != CENTER && al != LEFT)
	al = LEFT;

    alignment = al;
    if(str != null) label = new String(str);

    font = new Font("Helvetica", Font.PLAIN, 16);
}
//______________________________________________________________________________
/**
 * The gadget Label. (null, center)
 * @param parent the component holding the Label.
 */
public	LabelGadget(Component parent)
{
    this(parent, null, CENTER);
}
//______________________________________________________________________________
/**
 * Sets the geometry
 * @see #setGeometry
 */
final public void realize()
{
    setGeometry();
}
//______________________________________________________________________________
/**
 * Changes the Gadget Label.
 * @param str the text of the Label.
 */
final public void setLabel(String str)
{
    label     = new String(str);

    setGeometry();
}
//______________________________________________________________________________
/**
 * Changes the Gadget Label.
 * @param al the new alignment
 */
final private void setAlignment(int al)
{
    if(al != RIGHT && al != CENTER && al != LEFT)
	al = LEFT;

    alignment = al;

    setGeometry();
}
//______________________________________________________________________________
/**
 * Installs the Gadget Label.
 */
private	void setGeometry()
{
    FontMetrics fmt = getFontMetrics(font);
    if(fmt == null) {
	resize(margin, margin);
	setReference(0, 0);
	return;
    }

    int h = 2 * margin + fmt.getHeight();
    int w = 2 * margin;
    if(label != null) w += fmt.stringWidth(label);

    int v = margin + fmt.getMaxAscent();
    int u = margin;

    switch(alignment) {
    case LEFT :
	u = margin;
	break;
    case RIGHT :
	u = w - margin;
	break;
    case CENTER :
	u = w / 2;
	break;
    }

    resize(w, h);
    setReference(u, v);
}
//______________________________________________________________________________
/**
 * Draws the Label.
 * @param g the specified Graphics window
 */
public void draw(Graphics g)
{
    if(label == null) return;
    FontMetrics fmt = getFontMetrics(font);
    if(fmt == null) return;

    int w = 2 * margin + fmt.stringWidth(label);

    Point o = reference();

    switch(alignment) {
    case RIGHT :
	o.x -=  w;
	break;
    case CENTER :
	o.x -=  w / 2;
	break;
    }

    g.setFont(getFont());
    g.setColor(getForeground());
    drawString(g, label, o.x, o.y);
}
//______________________________________________________________________________

}


