//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.applet;

import java.awt.*;
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;

/**
 * HelpWindow : a component used as the main windown for application gui.
 * @version $Id: HelpWindow.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class HelpWindow extends Frame implements ActionListener {
  /**
   * @serial The unique instance.
   */
private  static HelpWindow window = null;
  /**
   * @serial The close command.
   */
private  static final String CLOSE = "C";
  /**
   * @serial The header of the text.
   */
private  JLabel title;
  /**
   * @serial The header of the text.
   */
private  JTextArea area;
  /**
   * @serial The prefix used to fetch resources.
   */
private  String prefix;

//______________________________________________________________________________
/**
 * Gets an unique instance of HelpWindow.
 * It is a singleton.
 * @return the instance.
 */
public static  HelpWindow  instance()
  {
    if(window == null) window = new HelpWindow(null);

    return window;
  }
//______________________________________________________________________________
/**
 * Gets an unique instance of MonthSet.
 * It is a singleton.
 * @parameter appli the name of the appli utilizing this object.
 * @return the instance.
 */
public static  HelpWindow  create(String appli)
  {
    if(window == null) window = new HelpWindow(appli);

    return window;
  }
//______________________________________________________________________________
/**
 * Creates the object.
 * @param str the title of the frame.
 */
private	HelpWindow(String appli)
  {
      final int space = 2;
      if(appli == null)
	  prefix = new String("HelpWindow");
      else
	  prefix = appli + ".Help";

      Resources resources = Resources.instance();

      setTitle("Help Window");
      setBackground(resources.get(prefix + ".Background",  Color.white));

      GridBagLayout grid      = new GridBagLayout();
      GridBagConstraints cons = new GridBagConstraints();
      cons.insets    = new Insets(space, space, space, space);
      cons.gridwidth = GridBagConstraints.REMAINDER;
      setLayout(grid);

      Font font = 
      resources.get(prefix + ".Header.Font", "SansSerif", Font.BOLD, 14);

      title = new JLabel("Help Window");
      title.setFont(font);
      grid.setConstraints(title, cons);
      add(title);

      font = 
      resources.get(prefix + ".Text.Font", "Serif", Font.PLAIN, 14);

      int cols = resources.get(prefix + ".ColumnS",  20);
      int rows = resources.get(prefix + ".Rows",     10);

      area = new JTextArea("", rows, cols);
      area.setEditable(false);
      area.setFont(font);
      grid.setConstraints(area, cons);
      add(area);

      JButton close = new JButton("Close");
      close.setFont(font);
      close.setActionCommand(CLOSE);
      close.addActionListener(this);
      grid.setConstraints(close, cons);
      add(close);

      int width  = resources.get(prefix + ".Width",  200);
      int height = resources.get(prefix + ".Height", 200);
      setSize(width, height);
  }
//______________________________________________________________________________
/**
 * Displays a help message.
 * @parameter header the title of the text.
 * @parameter text the text of the message.
 */
public void display(String header, String text)
{
    if(ToolBox.debug) ToolBox.warn("Displaying help " + header);
    title.setText(header);
    area.setText(text);
    setVisible(true);
}
//______________________________________________________________________________
/**
 * Closes the window when the button is pressed.
 * @parameter ev the event generated by the buttons.
 */
public void actionPerformed(ActionEvent ev)
{
    if(ev.getActionCommand().equals(CLOSE)) {
	setVisible(false);
    }
}
//______________________________________________________________________________
}

