//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.applet;

import java.awt.*;
import java.net.URL;
import java.util.StringTokenizer;
import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;

/**
 * AwtForm : a base object for Applets.
 * <Br>
 * It is a simplified version not using Swing.
 * <P>
 * Some attributes are set from resources.
 * It may display a title at the top of the form.
 * It may display a message line at the bottom.
 * The layout is set to GridBagLayout.
 *
 * @see GridBagLayout
 * @version $Id: AwtForm.java,v 3.2 2000/08/28 09:33:09 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public class AwtForm extends java.applet.Applet {

/**
 * @serial The size of the margins.
 */
public static final int SPACE = 4;
/**
 * @serial The object managing the layout.
 */
protected GridBagLayout      grid;
/**
 * @serial The object defining the constraints.
 */
protected GridBagConstraints cons;
  /**
   * @serial The label used to display messages.
   */
protected Label msgline;
/**
 * @serial The bag of utilities.
 */
protected Resources resources;
/**
 * @serial The flag indicating whether the applet is used on the web.
 */
protected boolean onweb = true;
  /*
   * @serial The string may be used to get properties.
   */
private static final String WEBFORM = "WebForm.";

//______________________________________________________________________________
/**
 * Builds the the common part of the applets.
 * <P>
 * The header parameter may be set to null.
 * <Br>
 * Draws a title. Make provision for resizing.
 * @parameter	header	the content of the title.
 */
public void init(String header)
  {
    //						First of all, set the options
      setMode();
      if(ToolBox.debug)
	  ToolBox.warn("Initializing "+ (header == null ? "AwtForm" : header));

      String jvs_lib = getLibDirectory();
      if(jvs_lib != null) {
	  try {
	      resources = Resources.instance();
	  }
	  catch(Exception ex) {
	      ToolBox.warn("Error when creating resources", ex);
	  }
      }

      ToolBox.warn("JVS Lib : " + resources.getLibDirectory());

      resources = Resources.instance();
      resources.load();

      setMode();
      setBackground();
      setDefaultFont();

    //						Then, prepare the layout
      grid = new GridBagLayout();
      cons = new GridBagConstraints();
      setLayout(grid);

      if(header == null) return;

      displayTitle(header);
  }
//______________________________________________________________________________
/**
 * Finds out where the jvs files are located.
 * <Br>
 * If it is an genuine applet, the location is the url of the JVS
 * archive. If not, null is returned.
 * <Br>
 * <Code>archive = "http://seipca185/lib/jvs.jar"</Code> provides
 * <Br>
 * <Code>"http://seipca185/lib"</Code>
 *
 * @return the url of the JVS.
 * @see	Resources#getLibDirectory
 */
final private String getLibDirectory()
  {
      if(! onweb) return null;

      String archives = getParameter("ARCHIVE");
      if(archives == null){
	  if(ToolBox.debug) ToolBox.warn("Can't find ARCHIVE value");
	  return null;
      }
      ToolBox.warn("Archives : " + archives);

      StringTokenizer stk = new StringTokenizer(archives, ",");

      while(stk.hasMoreTokens()) {
	  String jar = stk.nextToken();
	  int index  = jar.indexOf("jvs.jar");
	  if(index > 0) {
	      int i = jar.startsWith("null") ? 4 : 0; // Netscape bug ?
	      return jar.substring(i, index - 1);
	  }
      }

      if(ToolBox.debug) ToolBox.warn("JVS lib not found in " + archives);
      return null;
  }
//______________________________________________________________________________
/**
 * Sets the mode from the Param tags in the html file.
 * <Br>
 * It can be unset, quiet, verbose or debug.
 * @see	ToolBox
 */
final private void setMode()
  {
      if(! onweb) return;

      String mode = getParameter("MODE");

    if(mode == null) {
      ToolBox.verbose = false;
      ToolBox.debug   = false;
      return;
    }
    else if(mode.equalsIgnoreCase("verbose")) {
      ToolBox.verbose = true;
      ToolBox.debug   = false;
    }
    else if(mode.equalsIgnoreCase("debug")) {
      ToolBox.verbose = true;
      ToolBox.debug   = true;
    }
    else if(mode.equalsIgnoreCase("quiet")) {
      ToolBox.verbose = false;
      ToolBox.debug   = false;
    }
    else {
      ToolBox.verbose = true;
      ToolBox.debug   = false;
      warn("Unknown mode : " + mode);
    }
  }
//______________________________________________________________________________
/**
 * Displays the title of the applet. If the input string is null returns.
 * @parameter header the text of the title.
 * @see	Label
 */
private	void displayTitle(String header)
{
    if(header == null) return;
    Label title    = new Label(header);

    cons.insets    = new Insets(2*SPACE, 0, 0, 0);
    cons.weightx   = 1;
    cons.anchor    = GridBagConstraints.CENTER;
    cons.gridwidth = GridBagConstraints.REMAINDER;
    grid.setConstraints(title, cons);

    Font font = resources.get(WEBFORM + "Title.Font", "Helvetica",Font.BOLD,16);
    title.setFont(font);

    add(title);
}
//______________________________________________________________________________
/**
 * Adds a label used to send message to the user.
 * @see Label
 * @see #sendMessage
 */
protected void addMessageLine()
{
    msgline	= new Label("Applet initialized !");

    Font font   = resources.get(WEBFORM + "Message.Font",
				"Times", Font.ITALIC, 14);
    msgline.setFont(font);
    msgline.setBackground(
		  resources.get(WEBFORM + "Message.Background", Color.cyan));

    msgline.setForeground(
		  resources.get(WEBFORM + "Message.Foreground", Color.black));

    cons.gridwidth = GridBagConstraints.REMAINDER;
    grid.setConstraints(msgline, cons);
    add(msgline);
}
//______________________________________________________________________________
/**
 * Changes the message displayed in the message area.
 * @parameter text the new text to display.
 * @see #clearMessage
 */
final public void sendMessage(String text)
{
    if(msgline != null) msgline.setText(text + " !");
}
//______________________________________________________________________________
/**
 * Removes the message displayed in the message area.
 */
final public void clearMessage()
{
    if(msgline != null) msgline.setText("");
}
//______________________________________________________________________________
/**
 * Sets the background color of the Awt Form.
 * Read the property WebForm.Background.
 * It can be left to the default or set to one of predefined Color.
 * @see	Color
 * @see	Resources#get
 */
final private void setBackground()
  {
    Color bg = resources.get(WEBFORM + "Background", Color.yellow);

    if(bg == null) return;

    setBackground(bg);
  }
//______________________________________________________________________________
/**
 * Sets the default font. The original font seems to be Dialog,
 * which is ugly.
 * @see	Font
 * @see	Toolkit#getFontList
 */
final private void setDefaultFont()
  {
      Font font = new Font("SansSerif", Font.PLAIN, 14);
      setFont(font);
  }
//______________________________________________________________________________
/**
 * Returns the constraints.
 * @return the variable cons.
 */
final private GridBagConstraints getConstraints()
  {
    return cons;
  }
//______________________________________________________________________________
/**
 * Prints a message on the status line.
 * Print it on stderr as well if mode is verbose.
 * @param	msg	a string
 * @param	ex	an exception.
 */
final public void warn(String msg, Exception ex)
  {
      String str = msg + " : " + ex + " !";
      if(onweb)	showStatus(str); 
      if(ToolBox.verbose)	System.err.println(str);
  }
//______________________________________________________________________________
/**
 * Prints a message on the status line.
 * Print it on stderr as well if mode is verbose.
 * @param	msg	a string
 */
final public void warn(String msg)
  {
      String str = msg + " !";
      if(onweb)	showStatus(str); 
      if(ToolBox.verbose)	System.err.println(str);
  }
//______________________________________________________________________________
}


