//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//	$Id: AppletIhm.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
//______________________________________________________________________________

package org.ariane.applet;

import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.BorderFactory;
import org.ariane.applet.WebForm;
import org.ariane.applet.HelpWindow;
import org.ariane.applet.Messenger;
import org.ariane.tools.ToolBox;

/**
 * AppletIhm : a test program.
 * @version $Id: AppletIhm.java,v 3.0 2000/08/23 13:15:32 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class AppletIhm extends WebForm implements ActionListener {

    /**
     * @serial the text field.
     */
private	JTextField  field;
    /**
     * @serial the buttons
     */
private	JButton	   plus, minus, help;
    /**
     * @serial the variable.
     */
private	int	   count = 0;
    /**
     * @serial the object providing messages.
     */
private	Messenger  msgr;
    /**
     * @serial the help window.
     */
private	HelpWindow window;
  /**
   * The commands.
   */
private  static final String PLUS  = "+";
private  static final String MINUS = "-";
private  static final String HELP  = "?";

//______________________________________________________________________________

public void	init()
  {
    showStatus("Building form ...");
    super.init("IHM");
    //						First of all, prepare the layout
    setSize(300, 150);

    //						Communication widgets
    plus	   = new JButton("+");
    cons.gridwidth = 1;
    cons.weightx   = 0.0;
    cons.weighty   = 0.0;
    cons.insets    = new Insets(2, 4, 2, 20);
    cons.anchor    = GridBagConstraints.WEST;
    grid.setConstraints(plus, cons);
    add(plus);
    plus.setActionCommand(PLUS);
    plus.addActionListener(this);

    field		= new JTextField(8);
    field.setBorder(BorderFactory.createLoweredBevelBorder());
    cons.weightx	= 0;
    cons.anchor		= GridBagConstraints.CENTER;
    grid.setConstraints(field, cons);
    add(field);

    minus		= new JButton("-");
    cons.weightx	= 0.0;
    cons.anchor  	= GridBagConstraints.EAST;
    cons.gridwidth      = GridBagConstraints.REMAINDER;
    grid.setConstraints(minus, cons);
    add(minus);
    minus.setActionCommand(MINUS);
    minus.addActionListener(this);

    help		= new JButton("help");
    cons.weightx	= 1.0;
    cons.anchor  	= GridBagConstraints.SOUTH;
    cons.gridwidth      = GridBagConstraints.REMAINDER;
    grid.setConstraints(help, cons);
    add(help);
    help.setActionCommand(HELP);
    help.addActionListener(this);
    window = HelpWindow.instance();

    addMessageLine();
    msgr = new Messenger(msgline);
    window = HelpWindow.create("HelpWindow");

    setVisible(true);
    showStatus("Communicator ready !");
  }
//______________________________________________________________________________

public void actionPerformed(ActionEvent ev)
{
    String cmd = ev.getActionCommand();

    if(cmd.equals(PLUS)) {
	count++; update();
    }
    else if(cmd.equals(MINUS)) {
	count--; update();
    }
    else if(cmd.equals(HELP)) {
	window.display("Help " + count,
		       "Congratulations : \nYou press the right button !");
    }
    else {
	count = -1;
    }
}
//______________________________________________________________________________

private void update()
  {
    field.setText("Count " + String.valueOf(count));
    msgr.display(field.getText());
  }
//______________________________________________________________________________

public void dump()
  {
    System.out.println("AppletCom !");
  }
//______________________________________________________________________________
}




