#! /bin/sh
#_______________________________________________________________________________
#
# Bourne shell script : xbrowser.sh
# ID : $Id: xbrowser.sh,v 1.4 2001/06/13 19:45:24 lefevre Exp $
#
# Jean-Paul Le Fvre - June 2001
# Usage : xbrowser.sh [args to XBrowser]
#
# This script MUST be updated !
# Your CLASSPATH MUST contain xmlrpc.jar and the XML parser jar
# defined by your property 'org.xml.sax.parser'
#_______________________________________________________________________________

if [ -z "$XB_HOME" ]; then
    echo "Define the environment variable XB_HOME telling where is XBrowser !"
    exit 1
fi
if [ -z "$JVS_HOME" ]; then
    JVS_HOME=/opt/JVS
fi

# Jars needed by the WebWader plugin. Update the path !
# Note that xmlrpc.jar and openxml-1.2.jar do not come with the WebWader
# but are freely available on the internet. See the doc.
# The file jvs.jar will be loaded by the option install of the plugin menu.

CLASSPATH=/opt/jars/xmlrpc.jar:/opt/jars/openxml-1.2.jar

# Jars coming with XBrowser.
CLASSPATH=$XB_HOME/lib/crimson.jar:$XB_HOME/lib/jaxp.jar:$CLASSPATH
CLASSPATH=$XB_HOME/xbrowser.jar:$CLASSPATH

cd $XB_HOME

echo "Starting XBrowser from $PWD ..."
echo "Using CLASSPATH : $CLASSPATH"

java  -Djvs.home=$JVS_HOME -cp $CLASSPATH xbrowser.XBrowser $*

#_______________________________________________________________________________
