#! /bin/sh
#_______________________________________________________________________________
#
#       Bourne shell script : runserver.sh
#	ID : $Id: runserver.sh,v 3.3 2000/09/18 09:21:38 lefevre Exp $
#
#   	Jean-Paul Le Fvre - CEA DAPNIA/SEI - July 1999
#   	Usage : runserver.sh [args to RunServer]
#_______________________________________________________________________________

echo "Starting the server for the calmoni database ..."

# Guess where the shared samba partition is mounted.
# Use environment variable JVSLIB if defined.
# Build the class path. Add Objy if available.

#  Linux machine Saclay

if [ ${MACH:=undef} = linux ]; then
    jvslib=${JVS_HOME:-/opt/JVS}/lib
    classpath=$jvslib/jvs.jar:$jvslib/OB.jar:$classpath
fi

#  Unix network Saclay

if [ ${SYSTEM_SETUP:=0} = 1 ]; then
    jvslib=${JVS_HOME:-/home/nt/mnt/lefevre/soft/JVS}/lib
    classpath=$jvslib/oojava.jar
    classpath=$jvslib/jvs.jar:$jvslib/OB.jar:$classpath
fi

#  Windows network Saclay

if [ ${OSTYPE:=0} = cygwin32 ]; then
    jvslib=${JVS_HOME:-"C:/Program Files/JVS"}/lib
    classpath="$jvslib"/oojava.jar
    classpath="$jvslib"/jvs.jar\;"$jvslib"/OB.jar\;$classpath
fi

#  Unix network Cern

if [ ${CERN_LEVEL:=no} = pro ]; then
    root=/afs/cern.ch
    jvslib=${JVS_HOME:-$root/user/j/jplf/soft/JVS}/lib
    classpath=$root/sw/lhcxx/specific/sun/Objectivity/5.0/java/lib/oojava.jar
    classpath=$jvslib/jvs.jar:$jvslib/OB.jar:$classpath
fi

echo "The JVS library is in $jvslib !"

java -Djava.security.manager \
     -Djava.security.policy="$jvslib"/jvs.policy \
     -DKeyStore.File="$jvslib"/keystore   \
     -cp "$classpath" hep.cms.calmoni.RunServer $*

#_______________________________________________________________________________


