#! /bin/sh
#_______________________________________________________________________________
#
#       Bourne shell script : runclient.sh
#	ID : $Id: runclient.sh,v 3.3 2000/09/18 09:21:38 lefevre Exp $
#
#   	Jean-Paul Le Fvre - CEA DAPNIA/SEI - July 1999
#   	Usage : runclient.sh -h | -c command -- args
#       Command : check, list, import, erase, view or  kill.
#       Separate args with -- .
#       Args    : -q|v|d -k key other args.
#_______________________________________________________________________________

print=echo
cmd=undef
usage="Usage : runclient.sh [ -c check|list|view|kill|import|erase ] -- [args] ..."
opt=

while [ -n "$1" ]
do
case	$1 in

	-c)	cmd=$2; shift	        ;; #		command to execute


	--)	shift; args=${*}
		break			;;

	-*) 	$print $usage
		exit 1			;;
esac
shift
done

if [ ${cmd} = list ]; then
    program=hep.cms.calmoni.DataLister

elif [ ${cmd} = check ]; then
    program=hep.cms.calmoni.CheckServer

elif [ ${cmd} = kill ]; then
    program=hep.cms.calmoni.KillServer

elif [ ${cmd} = view ]; then
    program=hep.cms.calmoni.gui.DataViewer

elif [ ${cmd} = import ]; then
    program=hep.cms.calmoni.DataImporter

elif [ ${cmd} = erase ]; then
    program=hep.cms.calmoni.DataEraser

else
   echo "Invalid command $cmd ! (Try : check, list, import, erase, view, kill)"
   exit 1 
fi

echo "Starting $program $args ..."

# Guess where the shared samba partition is mounted.
# Use environment variable JVS_HOME if defined.
# Build the class path.

if [ ${MACH:=undef} = linux ]; then
    jvslib=${JVS_HOME:-/opt/JVS}/lib
    classpath=$jvslib/jvs.jar:$jvslib/OB.jar:$jvslib/xml.jar
    opt=-green
fi

if [ ${OSTYPE:=0} = cygwin32 ]; then
    jvslib=${JVS_HOME:-"C:/Program Files/JVS"}/lib
    classpath="$jvslib"/jvs.jar\;"$jvslib"/OB.jar\;"$jvslib"/xml.jar
fi

if [ ${SYSTEM_SETUP:=0} = 1 ]; then
    jvslib=${JVS_HOME:-/home/nt/mnt/lefevre/soft/JVS}/lib
    classpath=$jvslib/jvs.jar:$jvslib/OB.jar:$jvslib/xml.jar
fi

if [ ${CERN_LEVEL:=no} = pro ]; then
    root=/afs/cern.ch
    jvslib=${JVS_HOME:-$root/user/j/jplf/soft/JVS}/lib
    classpath=$jvslib/jvs.jar:$jvslib/OB.jar:$jvslib/xml.jar
fi

echo "The JVS library is in $jvslib !"

java $opt -cp "$classpath" $program $args

#_______________________________________________________________________________


