#_______________________________________________________________________________

# RPM specifications. Jean-Paul Le Fevre - September 2000
# $Id: webwader.spec,v 1.20 2001/06/19 19:20:23 lefevre Exp $
#_______________________________________________________________________________

# It is considered as a noarch package since it is written in Java.
# However test programs like print_url which come with this package
# are for Linux. They are only used for debugging.
#_______________________________________________________________________________

Summary : A tool to peruse automatically and thoroughly a web site.
Name    : webwader
Vendor  : Fonteny
Version : 2.4
Release : 0
Prefix  : /usr/local
Source  : http://jeanpaul.lefevre.free.fr/pub/%{name}-%{version}.%{release}.tgz
Group   : Networking/WWW
Requires  : jdk >= 1.2
Copyright : GPL
Buildroot : /var/tmp/
BuildArch : noarch
Packager  : Jean-Paul Le Fvre <JP.LeFevre@free.fr>

%define package JVS
%define jvs_home /opt/%{package}
%define launcher %{prefix}/bin/webwader 

%description
WebWader is a freely available utility to browse a web site.
It can traverse automatically and thoroughly a tree of html pages,
displaying each of them in a window supplied by the application itself
or by an external browser like Netscape or Internet Explorer. It is
written in 100% pure Java and can be used on various OS.

%prep
echo Installation of %{name} > %{_report}
echo jvs_home  %{jvs_home}  >> %{_report}
echo launcher  %{launcher}  >> %{_report}
echo RPM_BUILD_ROOT $RPM_BUILD_ROOT >> %{_report}
echo RPM_BUILD_DIR  $RPM_BUILD_DIR  >> %{_report}

%setup -n JVS

%build

%install

dest=$RPM_BUILD_ROOT%{jvs_home}
echo Installing from $PWD to  $dest

install -d $dest
install README COPYING $dest

cd bin
install -d $dest/bin
install w*.* b*.* xb*.* print_url send_url XjShowURL README $dest/bin
cd ..

cd lib
install -d $dest/lib
install *.* README Makefile $dest/lib
cd images
install -d $dest/lib/images
install *.* Makefile $dest/lib/images
cd ..
cd xml
install -d $dest/lib/xml
install *.* Makefile $dest/lib/xml
cd ../..

%post
ln -sf $RPM_BUILD_ROOT%{jvs_home}/bin/webwader.sh %{launcher}

%postun

%clean
rm -fr $RPM_BUILD_DIR/%{package}

%files
%defattr(644, root, root, 755)

%dir %{jvs_home}
%{jvs_home}/README
%{jvs_home}/COPYING

%dir %{jvs_home}/bin
%attr(755,root,root) %{jvs_home}/bin/w*.*
%attr(755,root,root) %{jvs_home}/bin/b*.*
%attr(755,root,root) %{jvs_home}/bin/xb*.*
%attr(755,root,root) %{jvs_home}/bin/print_url
%attr(755,root,root) %{jvs_home}/bin/send_url
%attr(755,root,root) %{jvs_home}/bin/XjShowURL
%{jvs_home}/bin/README

%dir %{jvs_home}/lib
%{jvs_home}/lib/*.*
%{jvs_home}/lib/README
%{jvs_home}/lib/Makefile

%dir %{jvs_home}/lib/images
%{jvs_home}/lib/images/*.*
%{jvs_home}/lib/images/Makefile

%dir %{jvs_home}/lib/xml
%{jvs_home}/lib/xml/*.*
%{jvs_home}/lib/xml/Makefile

%changelog

* Mon Jun 25 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Communication with Mozilla on Windows implemented.
* Mon Jun 4 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Communication with XBrowser using Xml-RPC implemented.
* Fri Apr 6 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Updated for KDE 2.1.
* Fri Feb 17 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Opera on Linux added.
* Sun Feb 11 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Documentation updated. Bugs fixed. NeoPlanet added.
* Sun Jan 21 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Documentation updated. Package tested on various platform.
* Mon Jan 14 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Remote browser harness implemented.
- Mozilla, IExplorer managed.
* Mon Jan 8 2001 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Remote browser harness implemented.
* Fri Dec 29 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Connection to SkipStone on Unix implemented.
* Mon Dec 25 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Connection to Galeon on Unix implemented.
* Sun Dec 3 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Connection to Amaya on Unix implemented.
* Mon Nov 20 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Connection to Konqueror implemented.
* Sun Nov 5 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Frames management improved. First XML implementation ready.
* Fri Nov 2 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Renaming completed : WebWader replaces webOrama.
- Save settings implemented. One more help option.
* Fri Oct 13 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Color resources added. Temp files automatically removed on exit.
- Connection to Emacs implemented.
- Mini navigation board added.
* Sun Oct 8 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Display or not a document depending on its type.
- Executables moved from lib to bin.
* Mon Oct 2 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Source RPM available. Bug fix for local files on Win32.
* Sun Sep 23 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- Use automake and autoconf.
* Sun Sep 15 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- RPM signed. Scripts fixed when directory name contains space.
* Sun Sep 3 2000 Jean-Paul Le Fvre <JP.LeFevre@free.fr>
- First RPM available.

#_______________________________________________________________________________
