#_______________________________________________________________________________

# JVS script for Nullsoft Installation System.
#
# If the optional source files are installed, the package can be recompiled.
# However it is recommended to use the zipped or the tarzipped package
# instead of the autoinstaller.
#
# NSIS doc is at : http://firehose.net/free/nsis/
# Jean-Paul Le Fvre - August 2000.
# $Id: webwader.nsi,v 1.5 2001/06/13 19:43:44 lefevre Exp $
#_______________________________________________________________________________

Name WebWader
Icon JVS\lib\images\installer.ico
OutFile webwader.exe
CRCCheck on
ComponentText "This will install the WebWader package"
LicenseText "This product is covered by the Gnu Public License"
LicenseData JVS\COPYING
DirText "Select a directory to install the JVS package for WebWader"

InstallDir $PROGRAMFILES\JVS
InstallDirRegKey HKEY_LOCAL_MACHINE SOFTWARE\JVS ""

InstType Standard
InstType Full

UninstallText "This will uninstall the JVS package for WebWader"
UninstallExeName uninstwader.exe
UninstallIcon JVS\lib\images\uninst.ico

#_______________________________________________________________________________

Section "Libraries (required)"
SectionIn 1
SetOverwrite on

SetOutPath $INSTDIR
File JVS\README
File JVS\COPYING
File JVS\AUTHORS

SetOutPath $INSTDIR\bin
File JVS\bin\README
File JVS\bin\w*.*
File JVS\bin\b*.*
File JVS\bin\x*.*
File JVS\bin\*.exe
File JVS\bin\jvshello.bat

SetOutPath $INSTDIR\lib
File JVS\lib\README
File JVS\lib\Makefile
File JVS\lib\*.*

SetOutPath $INSTDIR\lib\images
File JVS\lib\images\*.*

SetOutPath $INSTDIR\lib\xml
File JVS\lib\xml\*.*

#_______________________________________________________________________________

Section "Sources files"
SectionIn 234
SetOverwrite on

SetOutPath $INSTDIR
File JVS\INSTALL
File JVS\NEWS
File JVS\ChangeLog
File JVS\Makefile*
File JVS\configure*
File JVS\aclocal.m4
File JVS\src.zip

SetOutPath $INSTDIR\adm
File JVS\adm\README
File JVS\adm\Makefile*
File JVS\adm\*.*
File JVS\adm\mk*

SetOutPath $INSTDIR\include
File JVS\include\README
File JVS\include\*.*
File JVS\include\Makefile

SetOutPath $INSTDIR\bin
File JVS\bin\Makefile*

SetOutPath $INSTDIR\doc
File JVS\doc\Makefile*

#_______________________________________________________________________________

Section -post
WriteRegStr HKEY_LOCAL_MACHINE SOFTWARE\JVS "" $INSTDIR
WriteRegStr HKEY_CURRENT_USER Environment "JVS_HOME" $INSTDIR
CreateShortCut '$DESKTOP\WebWader.lnk' 'cscript.exe' '//B //nologo "$INSTDIR\bin\webwader.vbs" -v' '$INSTDIR\lib\images\webwader.ico' 0
CreateShortCut '$DESKTOP\WebBrowser.lnk' 'cscript.exe' '//B //nologo "$INSTDIR\bin\browser.vbs" -v' '$INSTDIR\lib\images\browser.ico' 0

#_______________________________________________________________________________

Section Uninstall
DeleteRegValue HKEY_CURRENT_USER Environment "JVS_HOME"
DeleteRegKey HKEY_LOCAL_MACHINE SOFTWARE\JVS
Delete $DESKTOP\WebWader.lnk

Delete $INSTDIR\src\*
Delete $INSTDIR\lib\images\*
Delete $INSTDIR\lib\xml\*
Delete $INSTDIR\lib\*
Delete $INSTDIR\include\*
Delete $INSTDIR\adm\*
Delete $INSTDIR\doc\*
Delete $INSTDIR\bin\*
Delete $INSTDIR\*

RMDir  $INSTDIR\src
RMDir  $INSTDIR\lib\images
RMDir  $INSTDIR\lib\xml
RMDir  $INSTDIR\lib
RMDir  $INSTDIR\include
RMDir  $INSTDIR\adm
RMDir  $INSTDIR\doc
RMDir  $INSTDIR\bin
RMDir  $INSTDIR

#_______________________________________________________________________________

