#! /bin/bash
#_______________________________________________________________________________
#
#       Bourne shell script : jvsdoc.sh
#	ID : $Id: jvsdoc.sh,v 3.9 2001/05/28 19:27:26 lefevre Exp $
#   	Jean-Paul Le Fvre - CEA DAPNIA/SEI - July 1999
#       Pure shell script. Do not use make. Can be lauched by the f*ing AT.
#_______________________________________________________________________________

export HOME=/home/lefevre
export PATH=/local/bin:/usr/bin:/bin:/opt/jdk1.3/bin
log=$HOME/tmp/jvsdoc.log

echo "Making JVS javadoc `date`" >$log
echo " " >>$log

export WEBDIR=$HOME/soft/Web
export JVS_HOME=$HOME/soft/JVS
export WEBDIR=$HOME/soft/Web
export JARLIB=/opt/jars
export XMLJARS=$JARLIB/sun/jaxp.jar:$JARLIB/sun/parser.jar:$JARLIB/xmlrpc.jar
export W4LIB=$JARLIB/w4
export W4JARS=$W4LIB/HTMLWindow.jar:$W4LIB/ib5core.jar:$W4LIB/ib5swing.jar
export W4JARS=$W4JARS:$W4LIB/Clue_scs310.jar

CLASSPATH=$JVS_HOME/src
CLASSPATH=$CLASSPATH:$JARLIB/ob/OB.jar:$XMLJARS:$JARLIB/servlet.jar
CLASSPATH=$CLASSPATH:/opt/share/objy/oojava.jar:$JARLIB/mysql.jar
CLASSPATH=$CLASSPATH:$W4JARS:$JARLIB/oracle/oracle12.zip

export CLASSPATH

cd $JVS_HOME/src
# 					Destination directory for html doc
DOCDIR=${WEBDIR}/lefevre/java/api
TITLE="<B>Java-Virtual-Shelf</B>"
DOCOPT="-author -version -private -doctitle ${TITLE} -header ${TITLE} -link http://java.sun.com/products/jdk/1.2/docs/api -d ${DOCDIR} -J-Xmx64m -J-Xms64m"

DOCOPT="${DOCOPT} -overview overview.html"
DOCOPT="${DOCOPT} -group \"Ariane\" \"org.ariane.*\""
DOCOPT="${DOCOPT} -group \"Demo\" \"org.demo.*\""
DOCOPT="${DOCOPT} -group \"Database\" \"org.oodb.*\""
DOCOPT="${DOCOPT} -group \"HEP\" \"hep.*\""

ARIANE="org.ariane.admin org.ariane.applet org.ariane.dbase"
ARIANE="${ARIANE} org.ariane.exec  org.ariane.net org.ariane.plot"
ARIANE="${ARIANE} org.ariane.stats org.ariane.time org.ariane.tools"
ARIANE="${ARIANE} org.ariane.orbec org.ariane.orbec.corba"
ARIANE="${ARIANE} org.ariane.orbec.corba.std org.ariane.security"
ARIANE="${ARIANE} org.ariane.gui"

DEMO="org.demo.bus org.demo.dbase org.demo.graphics"
DEMO="${DEMO} org.demo.network org.demo.palette"
DEMO="${DEMO} org.demo.stats org.demo.visitor"
DEMO="${DEMO} org.demo.bookmarks org.demo.orbec org.demo.bridge"
DEMO="${DEMO} org.demo.bridge.corba org.demo.bridge.corba.A"
DEMO="${DEMO} org.demo.bridge.corba.B org.demo.xml"
DEMO="${DEMO} org.demo.mts org.demo.mts.gui org.demo.orbec.corba"
DEMO="${DEMO} org.demo.mts.jdb org.benchmark.gauss"
DEMO="${DEMO} org.demo.orbec.corba.A org.demo.orbec.corba.B"
DEMO="${DEMO} org.demo.cddb org.demo.webwader org.demo.webwader.gui"
DEMO="${DEMO} org.demo.webwader.rbi org.demo.webwader.xmlrpc org.demo.roa"

OODB="org.oodb.bdms org.oodb.bdms.ascii org.oodb.bdms.serial"
OODB="${OODB} org.oodb.bdms.objy org.oodb.objy"
OODB="${OODB} org.oodb.bdnet org.oodb.bdnet.corba"
OODB="${OODB} org.oodb.bdnet.corba.serial org.oodb.bdnet.corba.objy"
OODB="${OODB} org.oodb.bdnet.corba.ascii"

HEP="hep.eros.edbg hep.eros.edbg.sql hep.cms.calmoni hep.cms.calmoni.corba"
HEP="${HEP} hep.cms.calmoni.corba.serial hep.cms.calmoni.corba.objy"
HEP="${HEP} hep.cms.calmoni.gui"

PACKAGES="${ARIANE} ${DEMO} ${OODB} ${HEP}"

echo "	Editing API documentation  ...." >>$log

javadoc ${DOCOPT} ${PACKAGES} >>$log 2>&1

echo " " >>$log
echo "Done `date` !" >>$log

#_______________________________________________________________________________



