#_______________________________________________________________________________

# JVS script for Nullsoft Installation System.
# NSIS doc is at : http://firehose.net/free/nsis/
# Jean-Paul Le Fvre - August 2000.
# $Id: jvs.nsi,v 3.3 2000/08/26 19:35:35 lefevre Exp $
#_______________________________________________________________________________

Name JVS
Icon JVS\lib\images\installer.ico
OutFile jvssetup.exe
CRCCheck on
ComponentText "This will install the JVS package"
LicenseText "This product is covered by the Gnu Public License"
LicenseData JVS\license.txt
DirText "Select a directory to install the JVS package"

InstallDir $PROGRAMFILES\JVS
InstallDirRegKey HKEY_LOCAL_MACHINE SOFTWARE\JVS ""

InstType Lite
InstType Standard
InstType Full

UninstallText "This will uninstall the JVS package"
UninstallExeName uninstjvs.exe
UninstallIcon JVS\lib\images\uninst.ico

#_______________________________________________________________________________

Section "Libraries (required)"
SectionIn 1
SetOverwrite on

SetOutPath $INSTDIR
File JVS\README
File JVS\license.txt

SetOutPath $INSTDIR\bin
File JVS\bin\README
File JVS\bin\*.*

SetOutPath $INSTDIR\include
File JVS\include\README
File JVS\include\*.*

SetOutPath $INSTDIR\lib
File JVS\lib\README
File JVS\lib\Makefile
File JVS\lib\*.*

SetOutPath $INSTDIR\lib\images
File JVS\lib\images\*.*

SetOutPath $INSTDIR\lib\xml
File JVS\lib\xml\*.*

#_______________________________________________________________________________

Section "Sources files"
SectionIn 234
SetOverwrite on

SetOutPath $INSTDIR
File JVS\src.zip

#_______________________________________________________________________________

Section -post
WriteRegStr HKEY_LOCAL_MACHINE SOFTWARE\JVS "" $INSTDIR
WriteRegStr HKEY_CURRENT_USER Environment "JVS_HOME" $INSTDIR
CreateShortCut $DESKTOP\jvs.lnk "cscript.exe" "//B //nologo $INSTDIR\bin\jvshello.vbs -v" "$INSTDIR\lib\images\jvs.ico" 0

#_______________________________________________________________________________

Section Uninstall
DeleteRegValue HKEY_CURRENT_USER Environment "JVS_HOME"
DeleteRegKey HKEY_LOCAL_MACHINE SOFTWARE\JVS
Delete $DESKTOP\jvs.lnk

Delete $INSTDIR\src\*
Delete $INSTDIR\lib\images\*
Delete $INSTDIR\lib\xml\*
Delete $INSTDIR\lib\*
Delete $INSTDIR\include\*
Delete $INSTDIR\bin\*
Delete $INSTDIR\*

RMDir  $INSTDIR\src
RMDir  $INSTDIR\lib\images
RMDir  $INSTDIR\lib\xml
RMDir  $INSTDIR\lib
RMDir  $INSTDIR\include
RMDir  $INSTDIR\bin
RMDir  $INSTDIR

#_______________________________________________________________________________

