#_______________________________________________________________________________

# Installation data for Calmoni.
# JVS script for Nullsoft Installation System.
# NSIS doc is at : http://firehose.net/free/nsis/
# Jean-Paul Le Fvre - August 2000.
# $Id: calmoni.nsi,v 3.4 2000/11/27 10:31:56 lefevre Exp $
#_______________________________________________________________________________

Name JVS
Icon JVS\lib\images\installer.ico
OutFile calmoni.exe
CRCCheck on
ComponentText "This will install the Calmoni application"
LicenseText "This product is developped by the CEA Saclay"
LicenseData JVS\src\hep\license.txt
DirText "Select a directory to install the JVS package"

InstallDir $PROGRAMFILES\JVS
InstallDirRegKey HKEY_LOCAL_MACHINE SOFTWARE\JVS ""

InstType Standard

UninstallText "This will uninstall the Calmoni application"
UninstallExeName uninstjvs.exe
UninstallIcon JVS\lib\images\uninst.ico

#_______________________________________________________________________________

Section "Libraries (required)"
SectionIn 1
SetOverwrite on

SetOutPath $INSTDIR
File JVS\README
File JVS\src\hep\license.txt

SetOutPath $INSTDIR\bin
File JVS\bin\README
File JVS\bin\*.*

SetOutPath $INSTDIR\include
File JVS\include\README
File JVS\include\*.*

SetOutPath $INSTDIR\lib
File JVS\lib\README
File JVS\lib\Makefile
File JVS\lib\*.*
File C:\Local\lib\OB.jar
File C:\Local\lib\\xml.jar

SetOutPath $INSTDIR\lib\images
File JVS\lib\images\*.*

SetOutPath $INSTDIR\lib\xml
File JVS\lib\xml\*.*

#_______________________________________________________________________________

Section -post
WriteRegStr HKEY_LOCAL_MACHINE SOFTWARE\JVS "" $INSTDIR
WriteRegStr HKEY_CURRENT_USER Environment "JVS_HOME" $INSTDIR
CreateShortCut '$DESKTOP\Calmoni Server.lnk' '"$INSTDIR\bin\runserver.bat"' '-v -c' '$INSTDIR\lib\images\runserver.ico' 0
CreateShortCut '$DESKTOP\Calmoni Client.lnk' '"$INSTDIR\bin\runclient.bat"' 'view -v' '$INSTDIR\lib\images\runclient.ico' 0

#_______________________________________________________________________________

Section Uninstall
DeleteRegValue HKEY_CURRENT_USER Environment "JVS_HOME"
DeleteRegKey HKEY_LOCAL_MACHINE SOFTWARE\JVS
Delete "$DESKTOP\Calmoni Server.lnk"
Delete "$DESKTOP\Calmoni Client.lnk"

Delete $INSTDIR\lib\images\*
Delete $INSTDIR\lib\xml\*
Delete $INSTDIR\lib\*
Delete $INSTDIR\include\*
Delete $INSTDIR\bin\*
Delete $INSTDIR\*

RMDir  $INSTDIR\lib\images
RMDir  $INSTDIR\lib\xml
RMDir  $INSTDIR\lib
RMDir  $INSTDIR\include
RMDir  $INSTDIR\bin
RMDir  $INSTDIR

#_______________________________________________________________________________

