dnl ____________________________________________________________________________

dnl @synopsis AC_TOMCAT
dnl
dnl AC_TOMCAT defines TOMCAT if argument is 'yes' and if the necessary
dnl files are present.
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_tomcat.m4,v 1.2 2000/09/28 10:40:48 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_TOMCAT],[

AC_MSG_CHECKING([whether the Tomcat file is  available ])
AC_CACHE_VAL(ac_cv_enable_tomcat, [

TOMCAT=no

dnl if full JVS is enabled default is yes, no otherwise.
if test "x$enableval" = x; then
     enableval="$FULLJVS"
fi

if test "x$enableval" = xyes; then

dnl   verify that the full jvs is enabled.
      if test x$FULLJVS != xyes; then
      	     ac_cv_enable_tomcat=no
      	     AC_MSG_RESULT([no])
	     AC_MSG_ERROR(the full JVS is not enabled !)
      fi

dnl   verify that the database related files are there.
      if test ! -f "$srcdir/src/org/ariane/net/JvsServlet.java"; then
      	     ac_cv_enable_tomcat=no
      	     AC_MSG_RESULT([no])
	     AC_MSG_ERROR(classes for accessing database are not there !)
      fi

dnl   verify that the classpath contains the driver.
      ac_jar=servlet.jar
      ac_count=`echo "$CLASSPATH" | grep -c "$ac_jar"`
      if test $ac_count -lt 1; then
      	    ac_cv_enable_tomcat=no
            AC_MSG_RESULT([no])
            AC_MSG_ERROR([Invalid CLASSPATH : add "$ac_jar".])
      fi

      ac_cv_enable_tomcat=yes
else
      ac_cv_enable_tomcat=no
fi
])
if test "$ac_cv_enable_tomcat" = yes; then
      TOMCAT=yes
fi
AC_MSG_RESULT([$TOMCAT])
])
dnl ____________________________________________________________________________
