dnl ____________________________________________________________________________

dnl @synopsis AC_OBJY
dnl
dnl AC_OBJY defines OBJY if argument is 'yes' and if the necessary
dnl files are present.
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_objy.m4,v 1.2 2000/09/28 10:40:48 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_OBJY],[

AC_MSG_CHECKING([whether the Objy file is available ])
AC_CACHE_VAL(ac_cv_enable_objy, [

OBJY=no

dnl if full JVS is enabled default is yes, no otherwise.
if test "x$enableval" = x; then
     enableval="$FULLJVS"
fi

if test "x$enableval" = xyes; then

dnl   verify that the full jvs is enabled.
      if test x$FULLJVS != xyes; then
      	     ac_cv_enable_objy=no
      	     AC_MSG_RESULT([no])
	     AC_MSG_ERROR(the full JVS is not enabled !)
      fi

dnl   verify that the database related files are there.
      if test ! -f "$srcdir/src/org/oodb/bdms/objy/ooVector.java"; then
      	     ac_cv_enable_objy=no
      	     AC_MSG_RESULT([no])
	     AC_MSG_ERROR(classes for accessing database are not there !)
      fi

dnl   verify that the classpath contains the driver.
      ac_jar=oojava.jar
      ac_count=`echo "$CLASSPATH" | grep -c "$ac_jar"`
      if test $ac_count -lt 1; then
      	    ac_cv_enable_objy=no
            AC_MSG_RESULT([no])
            AC_MSG_ERROR([Invalid CLASSPATH : add "$ac_jar".])
      fi

      ac_cv_enable_objy=yes
else
      ac_cv_enable_objy=no
fi
])
if test "$ac_cv_enable_objy" = yes; then
      OBJY=yes
fi
AC_MSG_RESULT([$OBJY])
])
dnl ____________________________________________________________________________
