dnl ____________________________________________________________________________

dnl @synopsis AC_FULL_JVS
dnl
dnl AC_FULL_JVS defines FULLJVS if argument is 'yes' and if the necessary
dnl files are present. If this package came with a webwader distribution
dnl the full JVS is not available.
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_full_jvs.m4,v 1.3 2000/10/25 19:20:50 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_FULL_JVS],[

AC_MSG_CHECKING([whether the full JVS is enabled ])
AC_CACHE_VAL(ac_cv_full_jvs, [

if test "x$enableval" != xno; then
dnl if the full JVS is wished check to see if calmoni is there.
      if test ! -f "$srcdir/src/hep/cms/calmoni/gui/package.html"; then
      	     ac_cv_full_jvs=no
	     AC_MSG_WARN(files for the full JVS are not there !)
      else
             ac_cv_full_jvs=yes
      fi
else
      ac_cv_full_jvs=no
fi
])
if test "$ac_cv_full_jvs" = yes; then
      FULLJVS=yes
else
      FULLJVS=no
fi
AC_MSG_RESULT([$FULLJVS])

])
dnl ____________________________________________________________________________
