dnl ____________________________________________________________________________

dnl @synopsis AC_CORBA
dnl
dnl AC_CORBA defines CORBA if argument is 'yes' and if the necessary
dnl files are present.
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_corba.m4,v 1.2 2000/09/28 13:26:50 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_CORBA],[

AC_MSG_CHECKING([whether the Orbec file is  available ])
AC_CACHE_VAL(ac_cv_enable_corba, [

CORBA=no

dnl if full JVS is enabled default is yes, no otherwise.
if test "x$enableval" = x; then
     enableval="$FULLJVS"
fi

if test "x$enableval" = xyes; then

dnl   verify that the full jvs is enabled.
      if test x$FULLJVS != xyes; then
      	     ac_cv_enable_corba=no
      	     AC_MSG_RESULT([no])
	     AC_MSG_ERROR(the full JVS is not enabled !)
      fi

dnl   verify that the database related files are there.
      if test ! -f "$srcdir/src/org/ariane/orbec/corba/NetFactory.idl"; then
      	     ac_cv_enable_corba=no
      	     AC_MSG_RESULT([no])
	     AC_MSG_ERROR(idl for creating objects are not there !)
      fi

dnl   verify that the classpath contains the OB jar file.
      ac_jar=OB.jar
      ac_count=`echo "$CLASSPATH" | grep -c "$ac_jar"`
      if test $ac_count -lt 1; then
      	    ac_cv_enable_corba=no
            AC_MSG_RESULT([no])
            AC_MSG_ERROR([Invalid CLASSPATH : add "$ac_jar".])
      fi

      ac_cv_enable_corba=yes
else
      ac_cv_enable_corba=no
fi
])
if test "$ac_cv_enable_corba" = yes; then
      CORBA=yes
fi
AC_MSG_RESULT([$CORBA])
])
dnl ____________________________________________________________________________
