dnl ____________________________________________________________________________

dnl @synopsis AC_COMPILE_JAVA_VERSION
dnl
dnl AC_COMPILE_JAVA_VERSION compile the class JavaVersion.
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_compile_java_version.m4,v 1.3 2000/10/03 15:47:55 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_COMPILE_JAVA_VERSION],[
AC_REQUIRE([AC_PROG_JAVAC])dnl

ac_java_version_code="$srcdir/src/org/ariane/test/JavaVersion.java"
AC_MSG_CHECKING([whether JavaVersion.java exists ])
if test ! -f $ac_java_version_code; then
      AC_MSG_RESULT([no])
      AC_MSG_ERROR([$ac_java_version_code not found, exiting.])
fi
AC_MSG_RESULT([yes])

AC_MSG_CHECKING([whether JavaVersion compiles ])

AC_CACHE_VAL(ac_cv_java_version_ok, [
eval $JAVAC $ac_java_version_code 1>/dev/null 2>&1
if test $? = 0; then
	ac_cv_java_version_ok=yes
else
	ac_cv_java_version_ok=no
      	AC_MSG_RESULT([no])
      	AC_MSG_ERROR([$ac_java_version_code does not compile, exiting.])
fi
])

AC_MSG_RESULT([yes])
])
dnl ____________________________________________________________________________
