dnl ____________________________________________________________________________

dnl @synopsis AC_CHECK_XMLRPC
dnl
dnl AC_CHECK_XMLRPC defines HAS_XMLRPC if argument is 'yes' and if the necessary
dnl files are present.
dnl
dnl @author Jean-Paul Le Fvre - April 2001.
dnl @version $Id: ac_check_xmlrpc.m4,v 3.1 2001/04/11 19:18:03 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_CHECK_XMLRPC],[

AC_MSG_CHECKING([whether the XMLRPC jar files are available ])
AC_CACHE_VAL(ac_cv_enable_xmlrpc, [

HAS_XMLRPC=no

if test "x$enableval" = xyes; then

dnl   verify that a class with xmlrpc object compiles.
      ac_sample=is_xmlrpc_available

cat << EOF > $ac_sample.java
      class $ac_sample {
      $ac_sample() {
	try {throw new helma.xmlrpc.XmlRpcException(0, "");}
	catch(Exception ex){}
      }}
EOF

      rm -f $ac_sample.class
      javac $ac_sample.java 1>/dev/null 2>&1

      if test -f $ac_sample.class; then
          rm -f $ac_sample.*
      else
      	  ac_cv_enable_xmlrpc=no
          AC_MSG_RESULT([no])
          AC_MSG_ERROR([XMLRPC jar files are not available.])
      fi

      if test "x$ac_cv_enable_xml" != xyes; then
      	  ac_cv_enable_xmlrpc=no
	  AC_MSG_RESULT([no])
	  AC_MSG_ERROR([XML must be enabled for XMLRPC.])
      else
      	  ac_cv_enable_xmlrpc=yes
      fi
else
      ac_cv_enable_xmlrpc=no
fi
])
if test "$ac_cv_enable_xmlrpc" = yes; then
      HAS_XMLRPC=yes
fi
AC_MSG_RESULT([$HAS_XMLRPC])
])
dnl ____________________________________________________________________________
