dnl ____________________________________________________________________________

dnl @synopsis AC_CHECK_XML
dnl
dnl AC_CHECK_XML defines HAS_XML if argument is 'yes' and if the necessary
dnl files are present.
dnl
dnl @author Jean-Paul Le Fvre - November 2000.
dnl @version $Id: ac_check_xml.m4,v 1.3 2001/01/14 17:44:57 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_CHECK_XML],[

AC_MSG_CHECKING([whether the XML jar files are available ])
AC_CACHE_VAL(ac_cv_enable_xml, [

HAS_XML=no

if test "x$enableval" = xyes; then

dnl   verify that a class with xml object compiles.
      ac_sample=is_xml_available

cat << EOF > $ac_sample.java
      class $ac_sample {
      $ac_sample() {
	try {throw new org.xml.sax.SAXException("");}
	catch(Exception ex){}
      }}
EOF

      rm -f $ac_sample.class
      javac $ac_sample.java 1>/dev/null 2>&1

      if test -f $ac_sample.class; then
          rm -f $ac_sample.*
      else
      	  ac_cv_enable_xml=no
          AC_MSG_RESULT([no])
          AC_MSG_ERROR([XML jar files are not available.])
      fi

      ac_cv_enable_xml=yes
else
      ac_cv_enable_xml=no
fi
])
if test "$ac_cv_enable_xml" = yes; then
      HAS_XML=yes
fi
AC_MSG_RESULT([$HAS_XML])
])
dnl ____________________________________________________________________________
