dnl ____________________________________________________________________________

dnl @synopsis AC_CHECK_RBI
dnl
dnl AC_CHECK_RBI checks if an external package used by the RBI
dnl is available or not.
dnl The variable corresponding to a package is built by AC_RBI_PROBE.
dnl
dnl @author Jean-Paul Le Fvre - January 2001.
dnl @version $Id: ac_check_rbi.m4,v 1.3 2001/05/28 15:03:10 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_RBI_PROBE], [ac_cv_probe_$1])

AC_DEFUN([AC_CHECK_RBI],[

ac_rbi_probe_class="$srcdir/src/org/demo/webwader/rbi/DisplayersProbe.class"
AC_MSG_CHECKING([whether DisplayersProbe.class exists ])
if test ! -f $ac_rbi_probe_class; then
      AC_MSG_RESULT([no])
      AC_MSG_ERROR([$ac_rbi_probe_class not found, exiting.])
fi
AC_MSG_RESULT([yes])

AC_MSG_CHECKING([whether $1 is available ])

AC_CACHE_VAL(AC_RBI_PROBE($1), [
AC_RBI_PROBE($1)=`java org.demo.webwader.rbi.DisplayersProbe $1 2>/dev/null`])

if test "$1" = "ClueDisplayer"; then
      HAS_CLUE=$AC_RBI_PROBE($1)
fi
if test "$1" = "IceDisplayer"; then
      HAS_ICE=$AC_RBI_PROBE($1)
fi
if test "$1" = "HorstDisplayer"; then
      HAS_HORST=$AC_RBI_PROBE($1)
fi
if test "$1" = "XBrowser"; then
      HAS_XBROWSER=$AC_RBI_PROBE($1)
fi

AC_MSG_RESULT([$AC_RBI_PROBE($1)])
])

dnl ____________________________________________________________________________

