dnl ____________________________________________________________________________

dnl @synopsis AC_CHECK_JVS_CLASSPATH
dnl
dnl AC_CHECK_JVS_CLASSPATH checks the CLASSPATH.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is based on the macros provided by :
dnl Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_check_jvs_classpath.m4,v 1.7 2000/10/22 15:05:47 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_CHECK_JVS_CLASSPATH],[

ac_pwd=`pwd`/src
dnl Try to handle the Win 32 situation.
dnl CLASSPATH must be a la Windows (\\) while pwd returns Unix path (/).
if test x$CYGWIN  = xyes; then
   ac_pwd=`cygpath -w "$ac_pwd"`
#   AC_MSG_WARN([The path to src is : "$ac_pwd"])
#   AC_MSG_WARN([while CLASSPATH is : "$CLASSPATH"])
fi
AC_MSG_CHECKING([whether CLASSPATH is defined ])
if test "x$CLASSPATH" = x; then
	AC_MSG_WARN([No CLASSPATH defined, it must contain "$ac_pwd".])
        AC_MSG_ERROR([Fix it first.])
fi
AC_MSG_RESULT([yes])

AC_MSG_CHECKING([whether CLASSPATH contains "$ac_pwd" ])

AC_CACHE_VAL(ac_cv_src_in_classpath, [

dnl The CLASSPATH separator is different on Windows and on Unix.
dnl Keep the origal field separator.
sep=$IFS
if test x$CYGWIN  = xyes; then
   IFS=";"
else
   IFS=":"
fi
ac_count=0
for cls in $CLASSPATH; do
    if test "$cls" = "$ac_pwd"; then
       ac_count=1
       break
    fi
done
IFS=$sep
if test $ac_count -lt 1; then
      ac_cv_src_in_classpath=no
      AC_MSG_RESULT([no])
      AC_MSG_ERROR([Invalid CLASSPATH : add "$ac_pwd".])
fi
ac_cv_src_in_classpath=yes])
AC_MSG_RESULT([yes])
])
dnl ____________________________________________________________________________
