dnl ____________________________________________________________________________

dnl @synopsis AC_CHECK_JAVA_VERSION
dnl
dnl AC_CHECK_JAVA_VERSION checks if installed java has a version
dnl number greater or equal than the one specified.
dnl
dnl @author Jean-Paul Le Fvre - September 2000.
dnl @version $Id: ac_check_java_version.m4,v 1.2 2000/09/27 12:03:00 lefevre Exp $

dnl ____________________________________________________________________________

AC_DEFUN([AC_CHECK_JAVA_VERSION],[

ac_java_version_class="$srcdir/src/org/ariane/test/JavaVersion.class"
AC_MSG_CHECKING([whether JavaVersion.class exists ])
if test ! -f $ac_java_version_class; then
      AC_MSG_RESULT([no])
      AC_MSG_ERROR([$ac_java_version_class not found, exiting.])
fi
AC_MSG_RESULT([yes])

AC_MSG_CHECKING([whether java version >= $1 ])

AC_CACHE_VAL(ac_cv_prog_java_version, [
ac_cv_prog_java_version=`java org.ariane.test.JavaVersion`])

if test $ac_cv_prog_java_version -lt $1; then
      AC_MSG_RESULT([no])
      AC_MSG_ERROR([java version is too low : $version])
fi
AC_MSG_RESULT([yes : $ac_cv_prog_java_version])
])

dnl ____________________________________________________________________________
