/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.xmlrpc;

import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcClientLite;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Vector;
import org.ariane.exec.ExecutionException;
import org.ariane.tools.ToolBox;
import org.demo.webwader.BadConfigurationException;
import org.demo.webwader.Resources;
import org.demo.webwader.gui.Displayer;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.xmlrpc.DisplayerServant;

public class XmlDisplayer
extends XmlRpcClientLite
implements Displayer {
    private static XmlDisplayer displayer = null;
    public static final String NAME = "XBrowser";
    private Vector param = new Vector(1, 1);

    public static XmlDisplayer instance() {
        if (displayer == null) {
            try {
                displayer = new XmlDisplayer();
            }
            catch (MalformedURLException malformedURLException) {
                ToolBox.warn("Can't create the XmlDisplayer", malformedURLException);
            }
            catch (BadConfigurationException badConfigurationException) {
                ToolBox.warn("Can't install the XML parser", badConfigurationException);
            }
        }
        return displayer;
    }

    private XmlDisplayer() throws MalformedURLException, BadConfigurationException {
        super("http://localhost:" + DisplayerServant.getPort());
        this.param.add(null);
        XmlDisplayer.setXmlDriver();
    }

    protected static void setXmlDriver() throws BadConfigurationException {
        String string = "org.xml.sax.parser";
        String string2 = Resources.instance().getProperties().getProperty(string, "org.openxml.parser.XMLParser");
        if (ToolBox.debug) {
            ToolBox.warn("XmlDriver : " + string2);
        }
        if (string2 == null) {
            throw new BadConfigurationException("No value for " + string);
        }
        try {
            XmlRpc.setDriver((String)string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BadConfigurationException(classNotFoundException.getMessage());
        }
    }

    public final void kill() throws ExecutionException {
        try {
            this.param.set(0, "RIP");
            this.execute("Displayer.kill", this.param);
            this.execute("Displayer.kill", this.param);
        }
        catch (SocketException socketException) {
            if (ToolBox.verbose) {
                ToolBox.warn("The server is dead");
            }
        }
        catch (Exception exception) {
            if (ToolBox.verbose) {
                ToolBox.warn("Can't kill the server", exception);
            }
            throw new ExecutionException(exception.getMessage());
        }
    }

    public final void activate() throws ExecutionException {
        try {
            GuiResources.instance();
            this.param.set(0, GuiResources.getWelcomeLocation());
            this.execute("Displayer.displayPage", this.param);
        }
        catch (Exception exception) {
            if (ToolBox.verbose) {
                ToolBox.warn("Can't execute displayPage", exception);
            }
            throw new ExecutionException(exception.getMessage());
        }
    }

    public final boolean displayPage(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            this.param.set(0, uRL.toExternalForm());
            return (Boolean)this.execute("Displayer.displayPage", this.param);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't display page " + uRL.toString(), exception);
            return false;
        }
    }

    public final String getName() {
        return NAME;
    }
}

