/*
 * Decompiled with CFR 0.152.
 */
package org.demo.webwader.xmlrpc;

import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;
import org.demo.webwader.Resources;
import org.demo.webwader.VersionInfo;
import org.demo.webwader.xmlrpc.DisplayerServant;

public class URLPrinter
extends TryProg {
    public static void main(String[] stringArray) {
        URLPrinter uRLPrinter = new URLPrinter();
        if (!uRLPrinter.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            TryProg.exitWrong();
        }
        if (!uRLPrinter.run()) {
            System.err.println("Can't execute URLPrinter !");
            TryProg.exitWrong();
        }
        System.exit(0);
    }

    public URLPrinter() {
        super("URLPrinter");
        this.setResources();
    }

    public boolean run() {
        if (ToolBox.debug) {
            System.out.println(VersionInfo.instance().toString());
        }
        try {
            DisplayerServant displayerServant = new DisplayerServant();
            System.out.println("Let the server work !");
            int n = Thread.activeCount();
            while (n > 1 && n < 3) {
                Thread.sleep(1000L);
                n = Thread.activeCount();
            }
            while (n > 2) {
                Thread.sleep(2000L);
                n = Thread.activeCount();
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't run URLPrinter " + exception);
            return false;
        }
        return true;
    }

    protected void setResources() {
        this.resources = Resources.instance();
    }

    private void printUsage() {
        System.out.println("Usage   : java org.demo.webwader.xmlrpc.URLPrinter [options]");
        System.out.println("Options : [-v|-d|-q][-V][-h]");
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'V': {
                        VersionInfo.print();
                        return false;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    default: {
                        this.printUsage();
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        return n2 == 0;
    }
}

